/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.doxygen;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Doxygen {
    private static final List<String> COMMANDS = List.of("a", "addindex", "addtogroup", "anchor", "arg", "attention", "author", "authors", "b", "brief", "bug", "c", "callergraph", "callgraph", "category", "cite", "class", "code", "collaborationgraph", "concept", "cond", "copybrief", "copydetails", "copydoc", "copyright", "date", "def", "defgroup", "deprecated", "details", "diafile", "dir", "directorygraph", "docbookinclude", "docbookonly", "dontinclude", "dot", "dotfile", "doxyconfig", "e", "else", "elseif", "em", "emoji", "endcode", "endcond", "enddocbookonly", "enddot", "endhtmlonly", "endif", "endinternal", "endlatexonly", "endlink", "endmanonly", "endmsc", "endparblock", "endrtfonly", "endsecreflist", "endverbatim", "enduml", "endxmlonly", "enum", "example", "exception", "extends", "file", "fileinfo", "fn", "groupgraph", "headerfile", "hidecallergraph", "hidecallgraph", "hidecollaborationgraph", "hidedirectorygraph", "hideenumvalues", "hidegroupgraph", "hideincludedbygraph", "hideincludegraph", "hideinheritancegraph", "hideinlinesource", "hiderefby", "hiderefs", "hideinitializer", "htmlinclude", "htmlonly", "idlexcept", "if", "ifnot", "image", "implements", "important", "include", "includedoc", "includedbygraph", "includegraph", "includelineno", "ingroup", "inheritancegraph", "internal", "invariant", "interface", "latexinclude", "latexonly", "li", "line", "lineinfo", "link", "mainpage", "maninclude", "manonly", "memberof", "module", "msc", "mscfile", "n", "name", "namespace", "noop", "nosubgrouping", "note", "overload", "p", "package", "page", "par", "paragraph", "param", "parblock", "post", "pre", "private", "privatesection", "property", "protected", "protectedsection", "protocol", "public", "publicsection", "pure", "qualifier", "raisewarning", "ref", "refitem", "related", "relates", "relatedalso", "relatesalso", "remark", "remarks", "result", "return", "returns", "retval", "rtfinclude", "rtfonly", "sa", "secreflist", "section", "see", "short", "showdate", "showenumvalues", "showinitializer", "showinlinesource", "showrefby", "showrefs", "since", "skip", "skipline", "snippet", "snippetdoc", "snippetlineno", "static", "startuml", "struct", "subpage", "subparagraph", "subsection", "subsubparagraph", "subsubsection", "tableofcontents", "test", "throw", "throws", "todo", "tparam", "typedef", "plantumlfile", "union", "until", "var", "verbatim", "verbinclude", "version", "vhdlflow", "warning", "weakgroup", "xmlinclude", "xmlonly", "xrefitem");

    private Doxygen() {
    }

    public static String commentsAsHtml(List<String> comments) {
        return comments.stream().map(t -> t.trim().replaceAll("^(?:/\\*|//|--)|(\\*/$)", "").trim()).filter(l -> l.startsWith("!")).map(t -> Arrays.stream(t.split("\\R")).map(line -> line.replaceAll("^[*!\\s]+", "").trim()).collect(Collectors.joining("\n"))).map(l -> {
            String text = l;
            for (String command : COMMANDS) {
                text = Doxygen.removeCommand(text, command).trim();
                text = text.replace("\n", " ");
            }
            return text;
        }).collect(Collectors.joining("<br>")).trim();
    }

    private static String removeCommand(String text, String command) {
        return text.replaceAll("([\\\\@])" + Pattern.quote(command) + "(\\s|$)", " ");
    }
}

