/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.slang.api;

import com.lintyservices.slang.helpers.Diagnostic;
import com.lintyservices.slang.helpers.SyntaxKind;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.ClassDeclaration;
import com.lintyservices.slang.trees.DesignUnitDeclaration;
import com.lintyservices.slang.trees.ModuleDeclaration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.scijava.nativelib.NativeLoader;

public class SlangParser {
    private long ref = SlangParser.init();
    private final Charset encoding;
    private final boolean capturingConsole;
    @Nullable
    private File logFile;

    public SlangParser() {
        this.encoding = StandardCharsets.UTF_8;
        this.capturingConsole = false;
        this.logFile = null;
    }

    public SlangParser(Charset encoding) {
        this.encoding = encoding;
        this.capturingConsole = false;
        this.logFile = null;
    }

    public SlangParser(Charset encoding, File logFile) {
        this.encoding = encoding;
        this.capturingConsole = true;
        this.logFile = logFile;
    }

    private static native long init() throws OutOfMemoryError;

    private static native void free_native(long var0);

    public final void free() {
        SlangParser.free_native(this.ref);
        this.ref = 0L;
    }

    @Deprecated
    public final void finalize() {
        if (this.ref != 0L) {
            System.err.println("Warning: SlangParser object not freed before garbage collection.\n");
            this.free();
        }
    }

    static native byte[] getCapturedStdout();

    static native byte[] getCapturedStderr();

    private void flushLog() {
        if (this.logFile != null) {
            try (FileOutputStream os = new FileOutputStream(this.logFile, true);){
                os.write(SlangParser.getCapturedStdout());
                os.write(SlangParser.getCapturedStderr());
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot write log file: " + this.logFile.getAbsolutePath());
            }
        }
    }

    public static native List<SyntaxKind> getAllSyntaxKinds();

    public native List<SyntaxNode> getSyntaxTrees();

    private native void parseCmdline(byte[][] var1);

    private native byte[] dumpAST();

    private native byte[] dumpASTPretty();

    private native boolean compile();

    public native List<Diagnostic> getDiagnostics();

    public native List<Diagnostic> getTidyDiagnostics();

    public void parse(File file) {
        this.parse(List.of(file));
    }

    public void parse(List<File> files) {
        List<byte[]> parserArgs = this.defaultArguments();
        for (File file : files) {
            parserArgs.add(file.getAbsolutePath().getBytes());
        }
        this.parseCmdline((byte[][])parserArgs.toArray((T[])new byte[0][]));
        this.flushLog();
        this.compile();
        this.flushLog();
    }

    public void parseFromCommandFile(File commandFile) {
        List<byte[]> parserArgs = this.defaultArguments();
        parserArgs.add(("-F" + commandFile.getAbsolutePath()).getBytes());
        this.parseCmdline((byte[][])parserArgs.toArray((T[])new byte[0][]));
        this.flushLog();
        this.compile();
        this.flushLog();
    }

    public String getAstFromFile(File file) {
        return this.getAstFromFiles(List.of(file));
    }

    public String getAstFromFiles(List<File> files) {
        this.parse(files);
        return new String(this.dumpASTPretty());
    }

    public String getAstFromCommandFile(File commandFile) {
        this.parseFromCommandFile(commandFile);
        return new String(this.dumpASTPretty());
    }

    public <E> List<E> getAll(Function<SyntaxNode, List<E>> search) {
        ArrayList finds = new ArrayList();
        for (SyntaxNode node : this.getSyntaxTrees()) {
            finds.addAll(search.apply(node));
        }
        return finds;
    }

    public List<SyntaxNode> getAll(SyntaxKind ... kinds) {
        ArrayList<SyntaxNode> finds = new ArrayList<SyntaxNode>();
        for (SyntaxNode node : this.getSyntaxTrees()) {
            finds.addAll(node.search(kinds));
        }
        return finds;
    }

    public Map<File, List<SyntaxNode>> getTokens(Set<File> files) {
        HashMap<File, List<SyntaxNode>> tokens = new HashMap<File, List<SyntaxNode>>();
        for (SyntaxNode node : this.getSyntaxTrees()) {
            File canonicalFile;
            File file = node.getAllTokens().get(0).location().file();
            try {
                canonicalFile = file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get canonical path from " + file.getAbsolutePath(), e);
            }
            if (!files.contains(canonicalFile)) continue;
            tokens.put(canonicalFile, node.getAllTokens());
        }
        return tokens;
    }

    public Map<File, List<SyntaxNode>> getTokens(File file) {
        return this.getTokens(Set.of(file));
    }

    public Map<File, List<SyntaxNode>> getDirectives(Set<File> files) {
        HashMap<File, List<SyntaxNode>> allDirectives = new HashMap<File, List<SyntaxNode>>();
        for (SyntaxNode node : this.getSyntaxTrees()) {
            File canonicalFile;
            File file = node.getAllTokens().get(0).location().file();
            try {
                canonicalFile = file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get canonical path from " + file.getAbsolutePath(), e);
            }
            if (!files.contains(canonicalFile)) continue;
            ArrayList<SyntaxNode> directives = new ArrayList<SyntaxNode>();
            for (SyntaxNode token : node.getAllTokens()) {
                directives.addAll(token.getDirectives());
            }
            allDirectives.put(canonicalFile, directives);
        }
        return allDirectives;
    }

    public Map<File, List<SyntaxNode>> getDirectives(File file) {
        return this.getDirectives(Set.of(file));
    }

    public Map<File, List<SyntaxNode>> getTokensAndDirectives(Set<File> files) {
        HashMap<File, List<SyntaxNode>> allTokensAndDirectives = new HashMap<File, List<SyntaxNode>>();
        for (SyntaxNode node : this.getSyntaxTrees()) {
            File canonicalFile;
            File file = node.getAllTokens().get(0).location().file();
            try {
                canonicalFile = file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get canonical path from " + file.getAbsolutePath(), e);
            }
            if (!files.contains(canonicalFile)) continue;
            List<SyntaxNode> tokens = node.getAllTokens();
            ArrayList<SyntaxNode> tokensAndDirectives = new ArrayList<SyntaxNode>(tokens);
            for (SyntaxNode token : tokens) {
                tokensAndDirectives.addAll(token.getDirectives());
            }
            allTokensAndDirectives.put(canonicalFile, tokensAndDirectives);
        }
        return allTokensAndDirectives;
    }

    public Map<File, List<SyntaxNode>> getTokensAndDirectives(File file) {
        return this.getTokensAndDirectives(Set.of(file));
    }

    public Map<File, List<SyntaxNode.Trivia>> getComments(Set<File> files) {
        HashMap<File, List<SyntaxNode.Trivia>> comments = new HashMap<File, List<SyntaxNode.Trivia>>();
        for (SyntaxNode node : this.getSyntaxTrees()) {
            File canonicalFile;
            File file = node.getAllTokens().get(0).location().file();
            try {
                canonicalFile = file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get canonical path from " + file.getAbsolutePath(), e);
            }
            if (!files.contains(canonicalFile)) continue;
            comments.put(canonicalFile, node.getAllTokens().stream().map(SyntaxNode::getComments).flatMap(Collection::stream).toList());
        }
        return comments;
    }

    public Map<File, List<SyntaxNode.Trivia>> getComments(File file) {
        return this.getComments(Set.of(file));
    }

    public List<Diagnostic> getAllDiagnostics() {
        Set<String> secondaryCodes = Set.of("General:NotePreviousDefinition", "General:NotePreviousUsage", "General:NoteDeclarationHere", "General:NotePreviousMatch", "General:NoteReferencedHere", "General:NoteAssignedHere", "General:NoteDrivenHere", "General:NoteOriginalAssign", "General:NoteConfigRule", "ConstEval:NoteInCallTo", "Tidy:NoteBlocking", "Tidy:NoteNonBlocking", "Tidy:NotePreviousCondition");
        List<Diagnostic> diagnostics = this.getDiagnostics();
        diagnostics.addAll(this.getTidyDiagnostics());
        ArrayList<Diagnostic> processedDiagnostics = new ArrayList<Diagnostic>();
        if (!diagnostics.isEmpty()) {
            Diagnostic currentDiagnostic = diagnostics.get(0);
            for (int i = 1; i < diagnostics.size(); ++i) {
                if (secondaryCodes.contains(diagnostics.get(i).id())) {
                    currentDiagnostic.addSecondaryLocation(diagnostics.get(i));
                    continue;
                }
                processedDiagnostics.add(currentDiagnostic);
                currentDiagnostic = diagnostics.get(i);
            }
            processedDiagnostics.add(currentDiagnostic);
        }
        return processedDiagnostics;
    }

    @Nullable
    public File logFile() {
        return this.logFile;
    }

    public static void main(String[] args2) {
        SlangParser parser = new SlangParser();
        byte[][] parserArgs = new byte[args2.length][];
        for (int i = 0; i < args2.length; ++i) {
            parserArgs[i] = args2[i].getBytes();
        }
        parser.parseCmdline(parserArgs);
        parser.compile();
        PrintStream out = System.out;
        out.println(new String(parser.dumpASTPretty()));
        out.println("\nDiagnostics:");
        for (Diagnostic diag : parser.getDiagnostics()) {
            out.println("\t" + diag.id() + " " + diag.location().toString() + " " + diag.message());
        }
        out.println("\nTidy diagnostics:");
        for (Diagnostic diag : parser.getTidyDiagnostics()) {
            out.println("\t" + diag.id() + " " + diag.location().toString() + " " + diag.message());
        }
        out.println("\nFound classes:");
        for (ClassDeclaration def : parser.getAll(ClassDeclaration::search)) {
            out.println("\t" + def.identifier().text() + " (" + def.location().toString() + ")");
        }
        out.println("\nTokens:");
        for (SyntaxNode token : parser.getSyntaxTrees().get(0).getAllTokens()) {
            for (SyntaxNode.Trivia trivia : token.getBlockComments()) {
                out.println("\t\t" + String.valueOf((Object)trivia.kind()) + " _" + trivia.text() + "_ " + (trivia.isPreprocessed() ? "preprocessed " : "") + (trivia.location() != null ? trivia.location().toString() : ""));
            }
            out.println("\t" + token.text() + " " + (token.isPreprocessed() ? "preprocessed " : "") + (token.isKeywordToken() ? "keyword " : "") + (token.location() != null ? token.location().toString() : ""));
        }
        out.println("\nModules:");
        for (ModuleDeclaration decl : parser.getAll(ModuleDeclaration::search)) {
            out.println("\t" + decl.identifier().text());
            for (DesignUnitDeclaration.Parameter param : decl.getParameters()) {
                out.println("\t\tparameter " + param.identifier().text() + (param.isImplicitlyTyped() ? " implicit" : "") + (param.isTypeParameter() ? " type" : ""));
            }
        }
        parser.free();
    }

    private List<byte[]> defaultArguments() {
        ArrayList<byte[]> arguments = new ArrayList<byte[]>();
        arguments.add("--error-limit=0".getBytes());
        if (this.encoding != StandardCharsets.UTF_8) {
            arguments.add("-Wno-invalid-source-encoding".getBytes());
        }
        arguments.addAll(Set.of("-Wno-error=bad-procedural-force", "-Wno-error=duplicate-definition", "-Wno-error=implicit-port-type-mismatch", "-Wno-error=index-oob", "-Wno-error=range-oob", "-Wno-error=specify-condition-expr", "-Wno-error=split-distweight-op").stream().map(String::getBytes).collect(Collectors.toSet()));
        return arguments;
    }

    static {
        try {
            NativeLoader.loadLibrary("linty-slang", new String[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load liblinty-slang", e);
        }
    }
}

