/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.slang.helpers;

import com.lintyservices.slang.helpers.Location;
import com.lintyservices.slang.helpers.LocationRange;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Diagnostic {
    private String id;
    private final String message;
    private List<Diagnostic> secondaryLocations;
    private Location location;
    private Severity severity;
    @Nullable
    private LocationRange locationRange;

    public Diagnostic(int code, String id, Subsystem subsystem, List<Location> expansionLocs, @Nullable List<LocationRange> ranges, Location location, String message, Severity severity) {
        List<LocationRange> sanitizedRanges;
        this.id = String.valueOf((Object)subsystem) + ":" + id;
        this.location = location;
        this.message = message;
        this.severity = severity;
        this.secondaryLocations = new ArrayList<Diagnostic>();
        if (ranges != null && !(sanitizedRanges = ranges.stream().filter(r -> !r.isEmpty()).toList()).isEmpty()) {
            this.locationRange = sanitizedRanges.get(0);
            for (int i = 1; i < sanitizedRanges.size(); ++i) {
                this.secondaryLocations.add(new Diagnostic("Secondary location", sanitizedRanges.get(i)));
            }
        }
    }

    public Diagnostic(String message, LocationRange locationRange) {
        this.message = message;
        this.locationRange = locationRange;
    }

    public String id() {
        return this.id;
    }

    public String message() {
        return this.message;
    }

    public Location location() {
        return this.location;
    }

    @Nullable
    public LocationRange locationRange() {
        return this.locationRange;
    }

    public List<Diagnostic> secondaryLocations() {
        return this.secondaryLocations;
    }

    public void addSecondaryLocation(Diagnostic secondaryLocation) {
        this.secondaryLocations.add(secondaryLocation);
    }

    public Severity severity() {
        return this.severity;
    }

    public static enum Severity {
        Ignored,
        Note,
        Warning,
        Error,
        Fatal;

    }

    public static enum Subsystem {
        Invalid,
        General,
        Lexer,
        Numeric,
        Preprocessor,
        Parser,
        Declarations,
        Expressions,
        Statements,
        Types,
        Lookup,
        SysFuncs,
        ConstEval,
        Compilation,
        Meta,
        Tidy,
        Netlist;

    }
}

