/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.sonar.plugins.bugfinder.BugFinderOutput;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderConstantOutputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderDirectlyConnectedPortsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFlipFlopNoResetAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderSetParametersAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderTopLevelInputPortMultipleClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnconnectedPortsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnregisteredLowLevelInputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnregisteredOutputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnregisteredTopLevelInputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVerificLogAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVisitor;
import com.lintyservices.sonar.plugins.bugfinder.yosys.YosysSetParameters;
import com.lintyservices.sonar.plugins.hdl.visitors.ConfigAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.visitors.SynthesisFilesToAnalyzeAwareVisitor;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.VerificLogItem;
import com.lintyservices.yosys.objects.YosysCell;
import com.lintyservices.yosys.objects.YosysConnectedPorts;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysPort;
import io.github.azagniotov.matcher.AntPathMatcher;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.config.Configuration;

public abstract class AbstractCodeAnalyzerSensor
implements Sensor {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractCodeAnalyzerSensor.class);
    private boolean hasBeenExecuted = false;

    public void injectFilesToAnalyzeIntoVisitors(List<Check> checks, Set<File> filesToAnalyze, Configuration config) {
        LOG.info("Injecting files to analyze into visitors...");
        for (Check check2 : checks) {
            Object v;
            if (check2 instanceof FilesToAnalyzeAwareVisitor) {
                v = (FilesToAnalyzeAwareVisitor)((Object)check2);
                v.setFilesToAnalyze(filesToAnalyze);
            }
            if (!(check2 instanceof SynthesisFilesToAnalyzeAwareVisitor)) continue;
            v = (SynthesisFilesToAnalyzeAwareVisitor)((Object)check2);
            v.setSynthesisFilesToAnalyze(filesToAnalyze.stream().filter(f -> this.isSynthesisFile((File)f, config)).collect(Collectors.toSet()));
        }
        LOG.info("Injecting files to analyze into visitors: Done");
    }

    public void injectDataIntoBugFinderVisitors(BugFinderOutput bugFinderOutput, Set<BugFinderVisitor> visitors, Set<File> filesToAnalyze, Configuration config) {
        Set<YosysPort> constantOutputPorts = bugFinderOutput.constantOutputPorts().stream().filter(p -> this.isFileToAnalyze(p.location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<YosysConnectedPorts> directlyConnectedPorts = bugFinderOutput.directlyConnectedPorts().stream().filter(p -> this.isFileToAnalyze(p.port().location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<YosysPort> unconnectedPorts = bugFinderOutput.unconnectedPorts().stream().filter(p -> this.isFileToAnalyze(p.location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<YosysPort> unregisteredOutputPorts = bugFinderOutput.unregisteredOutputPorts().stream().filter(p -> this.isFileToAnalyze(p.location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<YosysPort> unregisteredTopLevelInputPorts = bugFinderOutput.unregisteredTopLevelInputPorts().stream().filter(p -> this.isFileToAnalyze(p.location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<YosysPort> unregisteredLowLevelInputPorts = bugFinderOutput.unregisteredLowLevelInputPorts().stream().filter(p -> this.isFileToAnalyze(p.location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<VerificLogItem> verificLogItem = bugFinderOutput.verificLogItems().stream().filter(i -> this.isFileToAnalyze(i.location(), filesToAnalyze)).collect(Collectors.toSet());
        Set<YosysCell> flipFlopsNoReset = bugFinderOutput.flipFlopsNoReset().stream().filter(p -> this.isFileToAnalyze(p.location(), filesToAnalyze)).collect(Collectors.toSet());
        YosysSetParameters setParameters = new YosysSetParameters(config);
        for (BugFinderVisitor visitor : visitors) {
            Object v;
            if (visitor instanceof BugFinderConstantOutputPortsAwareVisitor) {
                v = (BugFinderConstantOutputPortsAwareVisitor)visitor;
                v.setConstantOutputPorts(constantOutputPorts);
            }
            if (visitor instanceof BugFinderDirectlyConnectedPortsAwareVisitor) {
                v = (BugFinderDirectlyConnectedPortsAwareVisitor)visitor;
                v.setDirectlyConnectedPorts(directlyConnectedPorts);
            }
            if (visitor instanceof BugFinderUnconnectedPortsAwareVisitor) {
                v = (BugFinderUnconnectedPortsAwareVisitor)visitor;
                v.setUnconnectedPorts(unconnectedPorts);
            }
            if (visitor instanceof BugFinderUnregisteredOutputPortsAwareVisitor) {
                v = (BugFinderUnregisteredOutputPortsAwareVisitor)visitor;
                v.setUnregisteredOutputPorts(unregisteredOutputPorts);
            }
            if (visitor instanceof BugFinderUnregisteredTopLevelInputPortsAwareVisitor) {
                v = (BugFinderUnregisteredTopLevelInputPortsAwareVisitor)visitor;
                v.setUnregisteredInputPorts(unregisteredTopLevelInputPorts);
            }
            if (visitor instanceof BugFinderUnregisteredLowLevelInputPortsAwareVisitor) {
                v = (BugFinderUnregisteredLowLevelInputPortsAwareVisitor)visitor;
                v.setUnregisteredInputPorts(unregisteredLowLevelInputPorts);
            }
            if (visitor instanceof BugFinderTopLevelInputPortMultipleClockDomainsAwareVisitor) {
                v = (BugFinderTopLevelInputPortMultipleClockDomainsAwareVisitor)visitor;
                v.setTopLevelInputPortMultipleClockDomains(bugFinderOutput.topLevelInputPortsMultipleClockDomains());
            }
            if (visitor instanceof BugFinderFlipFlopNoResetAwareVisitor) {
                v = (BugFinderFlipFlopNoResetAwareVisitor)visitor;
                v.setCells(flipFlopsNoReset);
            }
            if (visitor instanceof BugFinderVerificLogAwareVisitor) {
                v = (BugFinderVerificLogAwareVisitor)visitor;
                v.setVerificLogItems(verificLogItem);
            }
            if (visitor instanceof BugFinderClockManagementModuleAwareVisitor) {
                v = (BugFinderClockManagementModuleAwareVisitor)visitor;
                v.setClockManagementModule(bugFinderOutput.clockManagementModule());
            }
            if (visitor instanceof BugFinderResetManagementModuleAwareVisitor) {
                v = (BugFinderResetManagementModuleAwareVisitor)visitor;
                v.setResetManagementModule(bugFinderOutput.resetManagementModule());
            }
            if (visitor instanceof ConfigAwareVisitor) {
                v = (ConfigAwareVisitor)((Object)visitor);
                v.setConfig(config);
            }
            if (!(visitor instanceof BugFinderSetParametersAwareVisitor)) continue;
            v = (BugFinderSetParametersAwareVisitor)visitor;
            v.setSetParameters(setParameters.setParameters());
        }
    }

    public boolean isSimulationFile(File file, Configuration config) {
        String projectBaseDir = config.get("sonar.projectBaseDir").orElse("");
        String fileRelativePath = file.getAbsolutePath();
        if (!projectBaseDir.isEmpty()) {
            fileRelativePath = fileRelativePath.substring(projectBaseDir.length() + 1);
        }
        for (String pattern : config.getStringArray("sonar.hdl.file.simulationPaths")) {
            AntPathMatcher pathMatcher = new AntPathMatcher.Builder().build();
            if (!pathMatcher.isMatch(pattern.replace("/", File.separator), fileRelativePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isFileToAnalyze(@Nullable YosysLocation location, Set<File> filesToAnalyze) {
        return location != null && FileUtils.contains(filesToAnalyze, location.file());
    }

    public boolean isSynthesisFile(File file, Configuration config) {
        return !this.isSimulationFile(file, config);
    }

    public void progressInfo(int current, int total, File file) {
        LOG.info("{}/{} {}", current, total, FileUtils.sanitizedPath(file.getAbsolutePath()));
    }

    public boolean hasBeenExecuted() {
        return this.hasBeenExecuted;
    }

    public void setHasBeenExecuted(boolean hasBeenExecuted) {
        this.hasBeenExecuted = hasBeenExecuted;
    }
}

