/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.slang.trees.GenericAlwaysBlock;
import com.lintyservices.sonar.plugins.AbstractCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.BugFinderSensor;
import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.VerilogCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.VhdlCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.bugfinder.BugFinderOutput;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderCDCsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderCombinationalLoopsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderDesignHierarchyAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderRDCsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVisitor;
import com.lintyservices.sonar.plugins.bugfinder.yosys.YosysSetParameters;
import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.checks.HdlCheckList;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleLocationAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleNameAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.clock.CDCs;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.combinationalloop.CombinationalLoops;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.DesignHierarchy;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.issues.CrossFileIssueSaver;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.ClockAndResetDomainUtils;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.DCUtils;
import com.lintyservices.sonar.plugins.hdl.reset.RDCs;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueSaver;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.linty.license.LicenseChecker;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.visitors.GenericAlwaysBlocksAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.VhdlFileTreeTuple;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentInstantiationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ProcessTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlFileTreeTuplesAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ProcessTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"hdl-analyzer"})
@DependsUpon(value={"verilog-analyzer"})
public class HdlCodeAnalyzerSensor
extends AbstractCodeAnalyzerSensor {
    private final CheckFactory checkFactory;
    private final FileSystem fileSystem;
    private final Configuration config;
    private final Set<File> filesToAnalyze;
    private final Charset charset;
    private final VhdlCodeAnalyzerSensor vhdlCodeAnalyzerSensor;
    private final VerilogCodeAnalyzerSensor verilogCodeAnalyzerSensor;
    private final BugFinderSensor bugFinderSensor;
    private IssueSaver issueSaver;
    @Nullable
    private ClockDomains clockDomains;
    @Nullable
    private ResetDomains resetDomains;
    @Nullable
    private DesignHierarchy designHierarchy;
    @Nullable
    private CDCs cdcs;
    @Nullable
    private RDCs rdcs;
    @Nullable
    private CombinationalLoops combinationalLoops;
    @Nullable
    private Fsms fsms;
    private HdlIssueLocation topModuleLocation;

    public HdlCodeAnalyzerSensor(FileSystem fileSystem, CheckFactory checkFactory, Configuration config, VhdlCodeAnalyzerSensor vhdlCodeAnalyzerSensor, VerilogCodeAnalyzerSensor verilogCodeAnalyzerSensor, BugFinderSensor bugFinderSensor) {
        this.fileSystem = fileSystem;
        this.charset = Charset.forName(config.get("sonar.sourceEncoding").orElse("UTF-8"));
        this.config = config;
        this.checkFactory = checkFactory;
        this.vhdlCodeAnalyzerSensor = vhdlCodeAnalyzerSensor;
        this.verilogCodeAnalyzerSensor = verilogCodeAnalyzerSensor;
        this.bugFinderSensor = bugFinderSensor;
        this.filesToAnalyze = this.computeFilesToAnalyze();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("HDL Code Analyzer").onlyOnLanguages(new String[]{"vhdl", "verilog"});
    }

    public void execute(SensorContext context) {
        Set freeHdlDesignerChecks;
        LOG.info("--- Running HDL Code Analyzer...");
        LOG.info("File Encoding: " + String.valueOf(this.charset));
        this.setHasBeenExecuted(true);
        boolean hdlDesigner = Product.hdlDesigner(context);
        boolean notHdlDesigner = !hdlDesigner;
        Checks checks = new Checks(this.checkFactory).registerCheckClasses("hdl", HdlCheckList.getChecks());
        List<HdlCheck> hdlChecks = checks.allChecks().stream().filter(HdlCheck.class::isInstance).map(c -> (HdlCheck)c).filter(c -> notHdlDesigner || c instanceof HdlDesignerCheck).toList();
        if (hdlDesigner && !(freeHdlDesignerChecks = hdlChecks.stream().filter(c -> !(c instanceof FreeHdlDesignerCheck)).collect(Collectors.toSet())).isEmpty()) {
            new LicenseChecker(context, "hdl", false).checkFromVsCode();
        }
        boolean bugFinderAndNotHdlDesigner = Product.bugFinder(this.config) && notHdlDesigner;
        this.issueSaver = new IssueSaver(context, checks, this.filesToAnalyze, this.mainFilesPredicate(), hdlDesigner);
        this.injectFilesToAnalyzeIntoVisitors(hdlChecks.stream().map(Check.class::cast).toList(), this.filesToAnalyze, this.config);
        if (notHdlDesigner) {
            this.topModuleLocation = this.computeTopModuleLocation();
            this.injectTreeFilesIntoVisitors(hdlChecks);
        }
        for (HdlCheck check2 : hdlChecks) {
            if (!(check2 instanceof CharsetAwareVisitor)) continue;
            CharsetAwareVisitor charsetAwareVisitor = (CharsetAwareVisitor)((Object)check2);
            charsetAwareVisitor.setCharset(this.charset);
        }
        if (bugFinderAndNotHdlDesigner) {
            this.injectDataIntoBugFinderVisitors(this.hdlBugFinderVisitors(hdlChecks));
        }
        this.saveCrossFilesIssues(this.getCrossFileChecks(hdlChecks));
        LOG.info("--- Running HDL Code Analyzer: Done");
    }

    public VerilogCodeAnalyzerSensor verilogCodeAnalyzerSensor() {
        return this.verilogCodeAnalyzerSensor;
    }

    public VhdlCodeAnalyzerSensor vhdlCodeAnalyzerSensor() {
        return this.vhdlCodeAnalyzerSensor;
    }

    @Nullable
    public ClockDomains getClockDomains() {
        return this.clockDomains;
    }

    @Nullable
    public ResetDomains getResetDomains() {
        return this.resetDomains;
    }

    @Nullable
    public CDCs getCDCs() {
        return this.cdcs;
    }

    @Nullable
    public RDCs getRDCs() {
        return this.rdcs;
    }

    @Nullable
    public CombinationalLoops getCombinationalLoops() {
        return this.combinationalLoops;
    }

    @Nullable
    public Fsms getFsms() {
        return this.fsms;
    }

    @Nullable
    public DesignHierarchy getDesignHierarchy() {
        return this.designHierarchy;
    }

    public Set<File> filesToAnalyze() {
        return this.filesToAnalyze;
    }

    public HdlIssueLocation topModuleLocation() {
        return this.topModuleLocation;
    }

    @Nullable
    private HdlIssueLocation computeTopModuleLocation() {
        if (this.topModuleName() == null) {
            return null;
        }
        HdlIssueLocation location = null;
        if (this.vhdlCodeAnalyzerSensor.hasBeenExecuted()) {
            location = this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(EntityTreeFile.class).stream().sorted(new TreeFileComparator()).toList().stream().filter(tf -> ((EntityDeclarationTree)tf.tree()).identifier().text().equals(this.topModuleName())).map(t -> new HdlIssueLocation(t.file(), ((EntityDeclarationTree)t.tree()).identifier(), null)).findFirst().orElse(null);
        }
        if (location != null) {
            return location;
        }
        if (this.verilogCodeAnalyzerSensor.hasBeenExecuted()) {
            location = this.verilogCodeAnalyzerSensor.moduleDeclarations().stream().filter(d -> d.identifier().text().equals(this.topModuleName())).map(d -> new HdlIssueLocation(d.identifier().location())).findFirst().orElse(null);
        }
        if (location != null) {
            return location;
        }
        throw new LintyException(String.format("Cannot find \"%s\" top module location", this.topModuleName()));
    }

    private FilePredicate mainFilesPredicate() {
        return this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguages(new String[]{"vhdl", "verilog"}));
    }

    private Set<File> computeFilesToAnalyze() {
        HashSet<File> files = new HashSet<File>();
        for (InputFile file : this.fileSystem.inputFiles(this.mainFilesPredicate())) {
            File f = new File(file.uri());
            try {
                files.add(new File(file.uri()).getCanonicalFile());
            }
            catch (IOException e) {
                throw new LintyException("Cannot get canonical path from " + f.getAbsolutePath(), e);
            }
        }
        return files;
    }

    private void saveCrossFilesIssues(Set<Check> checks) {
        LOG.info("Saving cross-file issues...");
        CrossFileIssueSaver.saveIssues(checks, this.issueSaver);
        LOG.info("Saving cross-file issues: Done");
    }

    private Set<BugFinderVisitor> hdlBugFinderVisitors(List<HdlCheck> hdlChecks) {
        return hdlChecks.stream().filter(BugFinderVisitor.class::isInstance).map(BugFinderVisitor.class::cast).collect(Collectors.toSet());
    }

    private void injectTreeFilesIntoVisitors(List<HdlCheck> visitors) {
        LOG.info("Injecting TreeFile data into visitors...");
        for (HdlCheck visitor : visitors) {
            Object v;
            if (visitor instanceof TopModuleLocationAwareVisitor) {
                v = (TopModuleLocationAwareVisitor)((Object)visitor);
                v.setTopModuleLocation(this.topModuleLocation);
            }
            if (visitor instanceof TopModuleNameAwareVisitor) {
                v = (TopModuleNameAwareVisitor)((Object)visitor);
                v.setTopModuleName(this.topModuleName());
            }
            if (visitor instanceof VhdlFileTreeTuplesAwareVisitor) {
                v = (VhdlFileTreeTuplesAwareVisitor)((Object)visitor);
                v.setVhdlFileTreeTuples(this.vhdlCodeAnalyzerSensor.fileTreeTuples());
            }
            if (!(visitor instanceof ProcessTreeFileAwareVisitor)) continue;
            v = (ProcessTreeFileAwareVisitor)((Object)visitor);
            v.setProcesses(this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(ProcessTreeFile.class));
        }
        LOG.info("Injecting TreeFile data into visitors: Done");
    }

    private void injectDataIntoBugFinderVisitors(Set<BugFinderVisitor> bugFinderVisitors) {
        super.injectDataIntoBugFinderVisitors(this.bugFinderSensor.bugFinderOutput(), bugFinderVisitors, this.filesToAnalyze, this.config);
        BugFinderOutput bugFinderOutput = this.bugFinderSensor.bugFinderOutput();
        List<VhdlFileTreeTuple> vhdlFileTreeTuples = null;
        HashSet<ProcessTreeFile> processes = new HashSet();
        if (this.vhdlCodeAnalyzerSensor.hasBeenExecuted()) {
            vhdlFileTreeTuples = this.vhdlCodeAnalyzerSensor.fileTreeTuples();
            processes = this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(ProcessTreeFile.class);
        }
        List<GenericAlwaysBlock> genericAlwaysBlocks = null;
        if (this.verilogCodeAnalyzerSensor.hasBeenExecuted()) {
            genericAlwaysBlocks = this.verilogCodeAnalyzerSensor.allAlwaysBlocks();
        }
        DCUtils dcUtils = new DCUtils(this.filesToAnalyze, vhdlFileTreeTuples, genericAlwaysBlocks, this.topModuleLocation, this.config);
        ClockAndResetDomainUtils clockAndResetDomainUtils = new ClockAndResetDomainUtils(this.filesToAnalyze, this.topModuleLocation, this.config);
        this.cdcs = new CDCs(bugFinderOutput.cdcs(), dcUtils);
        this.rdcs = new RDCs(bugFinderOutput.rdcs(), dcUtils, clockAndResetDomainUtils);
        this.clockDomains = new ClockDomains(bugFinderOutput.clockDomains(), bugFinderOutput.clockManagementModule(), clockAndResetDomainUtils);
        this.resetDomains = new ResetDomains(bugFinderOutput.resetDomains(), bugFinderOutput.resetManagementModule(), clockAndResetDomainUtils);
        this.combinationalLoops = new CombinationalLoops(bugFinderOutput.combinationalLoops(), this.filesToAnalyze);
        this.fsms = new Fsms(bugFinderOutput.fsms(), this.filesToAnalyze);
        this.designHierarchy = new DesignHierarchy(bugFinderOutput.designHierarchy(), bugFinderOutput.clockManagementModule(), bugFinderOutput.resetManagementModule(), this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(EntityTreeFile.class), this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(ArchitectureTreeFile.class), this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(ComponentInstantiationTreeFile.class), this.vhdlCodeAnalyzerSensor.treeFileVisitor().get(ComponentTreeFile.class), this.verilogCodeAnalyzerSensor.moduleDeclarations(), this.verilogCodeAnalyzerSensor.hierarchicalInstances(), new YosysSetParameters(this.config).setParameters(), this.filesToAnalyze);
        for (BugFinderVisitor visitor : bugFinderVisitors) {
            Object bfVisitor;
            BugFinderVisitor v;
            if (visitor instanceof BugFinderClockDomainsAwareVisitor) {
                v = (BugFinderClockDomainsAwareVisitor)visitor;
                v.setClockDomains(this.clockDomains);
            }
            if (visitor instanceof BugFinderResetDomainsAwareVisitor) {
                v = (BugFinderResetDomainsAwareVisitor)visitor;
                v.setResetDomains(this.resetDomains);
            }
            if (visitor instanceof BugFinderCDCsAwareVisitor) {
                v = (BugFinderCDCsAwareVisitor)visitor;
                v.setCDCs(this.cdcs);
            }
            if (visitor instanceof BugFinderRDCsAwareVisitor) {
                v = (BugFinderRDCsAwareVisitor)visitor;
                v.setRDCs(this.rdcs);
            }
            if (visitor instanceof BugFinderCombinationalLoopsAwareVisitor) {
                v = (BugFinderCombinationalLoopsAwareVisitor)visitor;
                v.setCombinationalLoops(this.combinationalLoops);
            }
            if (visitor instanceof BugFinderDesignHierarchyAwareVisitor) {
                v = (BugFinderDesignHierarchyAwareVisitor)visitor;
                v.setDesignHierarchy(this.designHierarchy);
            }
            if (visitor instanceof BugFinderFsmsAwareVisitor) {
                bfVisitor = (BugFinderFsmsAwareVisitor)visitor;
                bfVisitor.setFsms(this.fsms);
            }
            if (visitor instanceof GenericAlwaysBlocksAwareVisitor) {
                bfVisitor = (GenericAlwaysBlocksAwareVisitor)((Object)visitor);
                bfVisitor.setGenericAlwaysBlocks(genericAlwaysBlocks != null ? new HashSet<GenericAlwaysBlock>(genericAlwaysBlocks) : new HashSet());
            }
            if (!(visitor instanceof ProcessTreeFileAwareVisitor)) continue;
            bfVisitor = (ProcessTreeFileAwareVisitor)((Object)visitor);
            bfVisitor.setProcesses(processes);
        }
    }

    private Set<Check> getCrossFileChecks(List<HdlCheck> hdlChecks) {
        return hdlChecks.stream().filter(CrossFileCheck.class::isInstance).collect(Collectors.toSet());
    }

    private String topModuleName() {
        return this.config.get("sonar.hdl.topModule").orElse(null);
    }
}

