/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.sonar.plugins.HdlCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.hdl.CDCsReport;
import com.lintyservices.sonar.plugins.hdl.ClockDomainsReport;
import com.lintyservices.sonar.plugins.hdl.CombinationalLoopsReport;
import com.lintyservices.sonar.plugins.hdl.DesignHierarchyReport;
import com.lintyservices.sonar.plugins.hdl.FSMsReport;
import com.lintyservices.sonar.plugins.hdl.RDCsReport;
import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.ReportGenerator;
import com.lintyservices.sonar.plugins.hdl.ResetDomainsReport;
import com.lintyservices.sonar.plugins.hdl.SummaryReport;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageTreeFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"report"})
@DependsUpon(value={"hdl-analyzer"})
public class ReportSensor
implements Sensor {
    private final Configuration config;
    private final HdlCodeAnalyzerSensor hdlCodeAnalyzerSensor;

    public ReportSensor(Configuration config, HdlCodeAnalyzerSensor hdlCodeAnalyzerSensor) {
        this.config = config;
        this.hdlCodeAnalyzerSensor = hdlCodeAnalyzerSensor;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("HDL Report").onlyOnLanguages(new String[]{"vhdl", "verilog"});
    }

    public void execute(SensorContext context) {
        Optional generateReport = this.config.get("sonar.hdl.report.enabled");
        if (generateReport.isPresent() && Boolean.parseBoolean((String)generateReport.get()) && !Product.hdlDesigner(context) && Product.bugFinder(this.config)) {
            HdlIssueLocation topModuleLocation = this.hdlCodeAnalyzerSensor.topModuleLocation();
            Set<File> filesToAnalyze = this.hdlCodeAnalyzerSensor.filesToAnalyze();
            ArrayList<Report> reports = new ArrayList<Report>();
            reports.add(new DesignHierarchyReport(this.hdlCodeAnalyzerSensor.getDesignHierarchy(), this.hdlCodeAnalyzerSensor.vhdlCodeAnalyzerSensor().treeFileVisitor().get(EntityTreeFile.class), this.hdlCodeAnalyzerSensor.vhdlCodeAnalyzerSensor().treeFileVisitor().get(PackageTreeFile.class), this.hdlCodeAnalyzerSensor.verilogCodeAnalyzerSensor().moduleDeclarations(), this.hdlCodeAnalyzerSensor.verilogCodeAnalyzerSensor().packageDeclarations(), this.hdlCodeAnalyzerSensor.verilogCodeAnalyzerSensor().interfaceDeclarations(), this.config));
            reports.add(new ClockDomainsReport(this.hdlCodeAnalyzerSensor.getClockDomains(), this.hdlCodeAnalyzerSensor.getDesignHierarchy(), filesToAnalyze, topModuleLocation, this.config));
            reports.add(new ResetDomainsReport(this.hdlCodeAnalyzerSensor.getResetDomains(), this.hdlCodeAnalyzerSensor.getDesignHierarchy(), filesToAnalyze, topModuleLocation, this.config));
            reports.add(new CDCsReport(this.hdlCodeAnalyzerSensor.getCDCs(), this.config));
            reports.add(new RDCsReport(this.hdlCodeAnalyzerSensor.getRDCs(), this.config));
            reports.add(new FSMsReport(this.hdlCodeAnalyzerSensor.getFsms(), this.config));
            reports.add(new CombinationalLoopsReport(this.hdlCodeAnalyzerSensor.getCombinationalLoops(), this.config));
            reports.add(new SummaryReport(new ArrayList<Report>(reports), this.config));
            new ReportGenerator(reports, this.config).generate();
        }
    }
}

