/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.slang.api.SlangParser;
import com.lintyservices.slang.trees.GenericAlwaysBlock;
import com.lintyservices.slang.trees.HierarchicalInstance;
import com.lintyservices.slang.trees.InterfaceDeclaration;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.slang.trees.PackageDeclaration;
import com.lintyservices.sonar.plugins.AbstractCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.CrossFileIssueSaver;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueSaver;
import com.lintyservices.sonar.plugins.linty.license.LicenseChecker;
import com.lintyservices.sonar.plugins.verilog.SlangDataInjector;
import com.lintyservices.sonar.plugins.verilog.VerilogCheck;
import com.lintyservices.sonar.plugins.verilog.checks.VerilogCheckList;
import com.lintyservices.sonar.plugins.verilog.computers.VerilogMetricsComputer;
import com.lintyservices.sonar.plugins.verilog.computers.VerilogSyntaxHighlighterComputer;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"verilog-analyzer"})
@DependsUpon(value={"vhdl-analyzer"})
public class VerilogCodeAnalyzerSensor
extends AbstractCodeAnalyzerSensor {
    private final FileSystem fileSystem;
    private final Configuration config;
    private final Charset charset;
    private final CheckFactory checkFactory;
    private final Set<File> filesToAnalyze;
    private List<ModuleDeclaration> moduleDeclarations = new ArrayList<ModuleDeclaration>();
    private List<PackageDeclaration> packageDeclarations = new ArrayList<PackageDeclaration>();
    private List<InterfaceDeclaration> interfaceDeclarations = new ArrayList<InterfaceDeclaration>();
    private List<HierarchicalInstance> hierarchicalInstances = new ArrayList<HierarchicalInstance>();
    private List<GenericAlwaysBlock> allAlwaysBlocks = new ArrayList<GenericAlwaysBlock>();

    public VerilogCodeAnalyzerSensor(FileSystem fileSystem, CheckFactory checkFactory, Configuration config) {
        this.fileSystem = fileSystem;
        this.checkFactory = checkFactory;
        this.config = config;
        this.charset = Charset.forName(config.get("sonar.sourceEncoding").orElse("UTF-8"));
        this.filesToAnalyze = this.filesToAnalyze();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Verilog/SystemVerilog Code Analyzer").onlyOnLanguages(new String[]{"verilog"});
    }

    public void execute(SensorContext context) {
        SlangParser parser;
        LOG.info("--- Running Verilog/SystemVerilog Code Analyzer...");
        LOG.info("File Encoding: " + String.valueOf(this.charset));
        this.setHasBeenExecuted(true);
        boolean hdlDesigner = Product.hdlDesigner(context);
        Checks checks = new Checks(this.checkFactory).registerCheckClasses("verilog", VerilogCheckList.getChecks());
        Set<VerilogCheck> verilogChecks = this.checks(checks, hdlDesigner);
        IssueSaver issueSaver = new IssueSaver(context, checks, this.filesToAnalyze, this.mainFilesPredicate(), hdlDesigner);
        if (hdlDesigner) {
            this.checkHdlDesignerLicense(context, verilogChecks);
        }
        if (hdlDesigner) {
            parser = new SlangParser(this.charset);
        } else {
            File slangLogFile = new File((String)this.config.get("sonar.projectBaseDir").get() + "/.linty/slang/output.log");
            parser = this.createSlangParser(this.charset, slangLogFile);
        }
        this.parseFiles(parser, hdlDesigner);
        SlangDataInjector slangDataInjector = this.injectSlangDataIntoChecks(verilogChecks, parser);
        if (!hdlDesigner) {
            new VerilogSyntaxHighlighterComputer(slangDataInjector.allTokensByFile(), context);
            new VerilogMetricsComputer(slangDataInjector.allTokensAndDirectivesByFile(), context);
        }
        this.saveCrossFilesIssues(verilogChecks, issueSaver);
        LOG.info("--- Running Verilog/SystemVerilog Code Analyzer: Done");
    }

    private SlangDataInjector injectSlangDataIntoChecks(Set<VerilogCheck> verilogChecks, SlangParser parser) {
        LOG.info("Injecting data into checks");
        SlangDataInjector slangDataInjector = new SlangDataInjector(verilogChecks, parser, this.filesToAnalyze, this.config);
        this.moduleDeclarations = slangDataInjector.moduleDeclarations();
        this.packageDeclarations = slangDataInjector.packageDeclarations();
        this.interfaceDeclarations = slangDataInjector.interfaceDeclarations();
        this.hierarchicalInstances = slangDataInjector.hierarchicalInstances();
        this.allAlwaysBlocks = slangDataInjector.allAlwaysBlocks();
        LOG.info("Injecting data into checks: Done");
        return slangDataInjector;
    }

    public List<ModuleDeclaration> moduleDeclarations() {
        return this.moduleDeclarations;
    }

    public List<PackageDeclaration> packageDeclarations() {
        return this.packageDeclarations;
    }

    public List<InterfaceDeclaration> interfaceDeclarations() {
        return this.interfaceDeclarations;
    }

    public List<HierarchicalInstance> hierarchicalInstances() {
        return this.hierarchicalInstances;
    }

    public List<GenericAlwaysBlock> allAlwaysBlocks() {
        return this.allAlwaysBlocks;
    }

    private FilePredicate mainFilesPredicate() {
        return this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("verilog"));
    }

    private Set<File> filesToAnalyze() {
        HashSet<File> files = new HashSet<File>();
        for (InputFile file : this.fileSystem.inputFiles(this.mainFilesPredicate())) {
            File f = new File(file.uri());
            try {
                files.add(new File(file.uri()).getCanonicalFile());
            }
            catch (IOException e) {
                throw new LintyException("Cannot get canonical path from " + f.getAbsolutePath(), e);
            }
        }
        return files;
    }

    private Set<VerilogCheck> checks(Checks checks, boolean hdlDesigner) {
        return checks.allChecks().stream().filter(VerilogCheck.class::isInstance).map(c -> (VerilogCheck)c).filter(c -> !hdlDesigner || c instanceof HdlDesignerCheck).collect(Collectors.toSet());
    }

    private void checkHdlDesignerLicense(SensorContext context, Set<VerilogCheck> verilogChecks) {
        Set freeHdlDesignerChecks = verilogChecks.stream().filter(c -> !(c instanceof FreeHdlDesignerCheck)).collect(Collectors.toSet());
        if (!freeHdlDesignerChecks.isEmpty()) {
            new LicenseChecker(context, "hdl", false).checkFromVsCode();
        }
    }

    private void parseFiles(SlangParser slangParser, boolean hdlDesigner) {
        LOG.info("Parsing files...");
        if (hdlDesigner) {
            File slangConfFile = new File((String)this.config.get("linty.baseDir").get() + File.separator + (String)this.config.get("sonar.verilog.slang.commandFilePath").get());
            boolean fileByFileAnalysis = false;
            Optional fileByFileAnalysisProperty = this.config.get("linty.hdlDesigner.fileByFileAnalysis");
            if (fileByFileAnalysisProperty.isPresent()) {
                fileByFileAnalysis = Boolean.parseBoolean((String)fileByFileAnalysisProperty.get());
            }
            if (!fileByFileAnalysis && slangConfFile.exists()) {
                try {
                    LOG.debug("Parsing from command file: {}", (Object)slangConfFile.getCanonicalFile().getAbsolutePath());
                }
                catch (IOException e) {
                    throw new LintyException("Cannot get canonical path from " + slangConfFile.getAbsolutePath(), e);
                }
                slangParser.parseFromCommandFile(slangConfFile);
            } else {
                LOG.debug("Parsing file(s): {}", (Object)this.filesToAnalyze.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")));
                slangParser.parse(this.filesToAnalyze.stream().toList());
            }
        } else {
            String commandFilePath = (String)this.config.get("sonar.projectBaseDir").get() + File.separator + (String)this.config.get("sonar.verilog.slang.commandFilePath").get();
            slangParser.parseFromCommandFile(new File(commandFilePath));
        }
        if (!hdlDesigner) {
            LOG.info("slang log output is available at " + FileUtils.sanitizedPath(slangParser.logFile().getAbsolutePath()));
        }
        LOG.info("Parsing files: Done");
    }

    private void saveCrossFilesIssues(Set<VerilogCheck> verilogChecks, IssueSaver issueSaver) {
        LOG.info("Checking code against activated rules...");
        Set<Check> checks = verilogChecks.stream().filter(CrossFileCheck.class::isInstance).collect(Collectors.toSet());
        CrossFileIssueSaver.saveIssues(checks, issueSaver);
        LOG.info("Checking code against activated rules: Done");
    }

    private SlangParser createSlangParser(Charset charset, File slangLogFile) {
        File parentDirectory = new File(slangLogFile.getParent());
        try {
            org.apache.commons.io.FileUtils.deleteDirectory(parentDirectory);
            Files.createDirectories(parentDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LintyException("Cannot create slang log file", e);
        }
        return new SlangParser(charset, slangLogFile);
    }

    private Set<BugFinderVisitor> verilogBugFinderVisitors(Set<VerilogCheck> verilogChecks) {
        return verilogChecks.stream().filter(BugFinderVisitor.class::isInstance).map(BugFinderVisitor.class::cast).collect(Collectors.toSet());
    }
}

