/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.sonar.plugins.AbstractCodeAnalyzerSensor;
import com.lintyservices.sonar.plugins.BugFinderSensor;
import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.bugfinder.BugFinderOutput;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderSynthesizedObjectsManagerAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderSynthesizedObjectsManagerOptionalAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVisitor;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.issues.CrossFileIssueSaver;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileScannerContext;
import com.lintyservices.sonar.plugins.hdl.visitors.SingleFileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueSaver;
import com.lintyservices.sonar.plugins.linty.language.issues.LineIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.sonar.plugins.linty.language.visitors.Visitor;
import com.lintyservices.sonar.plugins.linty.license.LicenseChecker;
import com.lintyservices.sonar.plugins.vhdl.api.VhdlCheck;
import com.lintyservices.sonar.plugins.vhdl.api.VhdlFileTreeTuple;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.VhdlSynthesizedObjectsManager;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Resets;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentInstantiationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ConfigurationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ConstantTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.DesignFileTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.FunctionTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageBodyTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ProcedureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ProcessTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SignalTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VariableTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.visitor.TreeVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.VhdlCheckList;
import com.lintyservices.sonar.plugins.vhdl.checks.active.linter.ParsingErrorCheck;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ArchitectureTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ComponentDeclarationTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ComponentInstantiationStatementTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ConfigurationTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ConstantTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.DesignFileTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.EntityTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.FunctionTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.PackageBodyTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.PackageTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ProcedureTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ProcessTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SignalTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TopEntityTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TreeFileVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.VariableTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.measures.visitors.VhdlMetricsVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RecordTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VhdlParser;
import com.lintyservices.sonar.plugins.vhdl.visitors.VhdlCpdVisitor;
import com.lintyservices.sonar.plugins.vhdl.visitors.VhdlSyntaxHighlighterVisitor;
import com.lintyservices.sonar.plugins.vhdl.visitors.VhdlSynthesizedVisitor;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.typed.ActionParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"vhdl-analyzer"})
@DependsUpon(value={"bug-finder"})
public class VhdlCodeAnalyzerSensor
extends AbstractCodeAnalyzerSensor {
    private final FileSystem fileSystem;
    private final Configuration config;
    private final BugFinderSensor bugFinderSensor;
    private final ActionParser<VhdlTree> parser;
    private final Charset charset;
    private final Set<File> filesToAnalyze;
    private final CheckFactory checkFactory;
    private ParsingErrorCheck parsingErrorCheck;
    private IssueSaver issueSaver;
    private List<VhdlFileTreeTuple> fileTreeTuples = new ArrayList<VhdlFileTreeTuple>();
    private final TreeFileVisitor treeFileVisitor = new TreeFileVisitor();

    public VhdlCodeAnalyzerSensor(FileSystem fileSystem, CheckFactory checkFactory, Configuration config, BugFinderSensor bugFinderSensor) {
        this.fileSystem = fileSystem;
        this.checkFactory = checkFactory;
        this.config = config;
        this.bugFinderSensor = bugFinderSensor;
        this.charset = Charset.forName(config.get("sonar.sourceEncoding").orElse("UTF-8"));
        this.parser = VhdlParser.createParser(this.charset);
        this.filesToAnalyze = this.filesToAnalyze();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("VHDL Code Analyzer").onlyOnLanguages(new String[]{"vhdl"});
    }

    public void execute(SensorContext context) {
        LOG.info("--- Running VHDL Code Analyzer...");
        LOG.info("File Encoding: " + String.valueOf(this.charset));
        this.setHasBeenExecuted(true);
        boolean hdlDesigner = Product.hdlDesigner(context);
        boolean notHdlDesigner = !hdlDesigner;
        Checks checks = new Checks(this.checkFactory).registerCheckClasses("vhdl", VhdlCheckList.getChecks());
        Set<VhdlCheck> vhdlChecks = checks.allChecks().stream().filter(VhdlCheck.class::isInstance).map(c -> (VhdlCheck)c).filter(c -> notHdlDesigner || c instanceof HdlDesignerCheck).collect(Collectors.toSet());
        if (hdlDesigner) {
            this.checkHdlDesignerLicense(context, vhdlChecks);
        }
        this.issueSaver = new IssueSaver(context, checks, this.filesToAnalyze, this.mainFilesPredicate(), hdlDesigner);
        this.setParsingErrorCheckIfActivated(vhdlChecks);
        this.fileTreeTuples = this.parseFiles();
        if (notHdlDesigner) {
            this.injectFilesToAnalyzeIntoVisitors(vhdlChecks.stream().map(Check.class::cast).toList(), this.filesToAnalyze, this.config);
            ArrayList<TreeVisitor<VhdlTree>> decoratorVisitors = new ArrayList<TreeVisitor<VhdlTree>>();
            VhdlSynthesizedObjectsManager synthesizedObjectsManager = null;
            if (Product.bugFinder(this.config)) {
                VhdlSynthesizedVisitor synthesizedVisitor = new VhdlSynthesizedVisitor();
                synthesizedObjectsManager = new VhdlSynthesizedObjectsManager(this.bugFinderSensor.bugFinderOutput().synthesizedObjects());
                synthesizedVisitor.setSynthesizedObjectsManager(synthesizedObjectsManager);
                decoratorVisitors.add(synthesizedVisitor);
            }
            decoratorVisitors.addAll(List.of(new VhdlCpdVisitor(context), new VhdlSyntaxHighlighterVisitor(context), new VhdlMetricsVisitor(context), this.treeFileVisitor));
            this.decorateFiles(this.fileTreeTuples, decoratorVisitors);
            if (Product.bugFinder(this.config)) {
                this.injectDataIntoBugFinderVisitors(synthesizedObjectsManager, this.vhdlBugFinderVisitors(vhdlChecks));
            }
            this.injectTreeFilesIntoVisitors(vhdlChecks);
        }
        List<IssueInterface> issues = this.gatherIssues(this.fileTreeTuples, vhdlChecks);
        this.saveSingleFileIssues(issues);
        if (notHdlDesigner) {
            this.saveCrossFilesIssues(this.getCrossFileChecks(vhdlChecks));
        }
        LOG.info("--- Running VHDL Code Analyzer: Done");
    }

    public List<VhdlFileTreeTuple> fileTreeTuples() {
        return this.fileTreeTuples;
    }

    private void checkHdlDesignerLicense(SensorContext context, Set<VhdlCheck> vhdlChecks) {
        Set freeHdlDesignerChecks = vhdlChecks.stream().filter(c -> !(c instanceof FreeHdlDesignerCheck)).collect(Collectors.toSet());
        if (!freeHdlDesignerChecks.isEmpty()) {
            new LicenseChecker(context, "hdl", false).checkFromVsCode();
        }
    }

    private FilePredicate mainFilesPredicate() {
        return this.fileSystem.predicates().and(this.fileSystem.predicates().hasType(InputFile.Type.MAIN), this.fileSystem.predicates().hasLanguage("vhdl"));
    }

    private Set<File> filesToAnalyze() {
        HashSet<File> files = new HashSet<File>();
        for (InputFile file : this.fileSystem.inputFiles(this.mainFilesPredicate())) {
            File f = new File(file.uri());
            try {
                files.add(new File(file.uri()).getCanonicalFile());
            }
            catch (IOException e) {
                throw new LintyException("Cannot get canonical path from " + f.getAbsolutePath(), e);
            }
        }
        return files;
    }

    public TreeFileVisitor treeFileVisitor() {
        return this.treeFileVisitor;
    }

    private List<VhdlFileTreeTuple> parseFiles() {
        LOG.info("Parsing files...");
        ArrayList<VhdlFileTreeTuple> fileTreeTuples = new ArrayList<VhdlFileTreeTuple>();
        int i = 1;
        int size = this.filesToAnalyze.size();
        for (File file : this.filesToAnalyze) {
            this.progressInfo(i, size, file);
            VhdlFileTreeTuple tuple = this.parseFile(file);
            if (tuple != null) {
                fileTreeTuples.add(tuple);
            }
            ++i;
        }
        LOG.info("Parsing files: Done");
        return fileTreeTuples;
    }

    private void decorateFiles(List<VhdlFileTreeTuple> fileTreeTuples, List<TreeVisitor<VhdlTree>> decoratorVisitors) {
        LOG.info("Decorating files...");
        int i = 1;
        int size = this.filesToAnalyze.size();
        for (VhdlFileTreeTuple tuple : fileTreeTuples) {
            this.progressInfo(i, size, tuple.file());
            this.scanFile(tuple.file(), tuple.tree(), decoratorVisitors);
            ++i;
        }
        LOG.info("Decorating files: Done");
    }

    private List<IssueInterface> gatherIssues(List<VhdlFileTreeTuple> fileTreeTuples, Set<VhdlCheck> vhdlChecks) {
        LOG.info("Analyzing files to gather issues...");
        ArrayList<IssueInterface> issues = new ArrayList<IssueInterface>();
        List<TreeVisitor<VhdlTree>> checkVisitors = vhdlChecks.stream().filter(TreeVisitor.class::isInstance).map(c -> (TreeVisitor)((Object)c)).toList();
        int i = 1;
        int size = this.filesToAnalyze.size();
        for (VhdlFileTreeTuple tuple : fileTreeTuples) {
            this.progressInfo(i, size, tuple.file());
            issues.addAll(this.scanFile(tuple.file(), tuple.tree(), checkVisitors));
            ++i;
        }
        LOG.info("Analyzing files to gather issues: Done");
        return issues;
    }

    private void injectDataIntoBugFinderVisitors(VhdlSynthesizedObjectsManager synthesizedObjectsManager, Set<BugFinderVisitor> bugFinderVisitors) {
        super.injectDataIntoBugFinderVisitors(this.bugFinderSensor.bugFinderOutput(), bugFinderVisitors, this.filesToAnalyze, this.config);
        BugFinderOutput bugFinderOutput = this.bugFinderSensor.bugFinderOutput();
        Clocks clocks = new Clocks(bugFinderOutput.clocks().stream().filter(c -> this.isFileToAnalyze(c.location(), this.filesToAnalyze)).collect(Collectors.toSet()), this.treeFileVisitor.get(EntityTreeFile.class), this.treeFileVisitor.get(ArchitectureTreeFile.class), synthesizedObjectsManager);
        Resets resets = new Resets(bugFinderOutput.resets().stream().filter(c -> this.isFileToAnalyze(c.location(), this.filesToAnalyze)).collect(Collectors.toSet()), this.treeFileVisitor.get(EntityTreeFile.class), this.treeFileVisitor.get(ArchitectureTreeFile.class));
        Enables enables = new Enables(bugFinderOutput.enables().stream().filter(c -> this.isFileToAnalyze(c.location(), this.filesToAnalyze)).collect(Collectors.toSet()), this.treeFileVisitor.get(EntityTreeFile.class), this.treeFileVisitor.get(ArchitectureTreeFile.class));
        Fsms fsms = new Fsms(bugFinderOutput.fsms(), this.filesToAnalyze, this.treeFileVisitor.get(ArchitectureTreeFile.class), this.treeFileVisitor.get(TypeTreeFile.class).stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof RecordTypeDefinitionTree).collect(Collectors.toSet()));
        for (BugFinderVisitor visitor : bugFinderVisitors) {
            Object bfVisitor;
            if (visitor instanceof BugFinderSynthesizedObjectsManagerOptionalAwareVisitor) {
                bfVisitor = (BugFinderSynthesizedObjectsManagerOptionalAwareVisitor)((Object)visitor);
                bfVisitor.setSynthesizedObjectsManager(synthesizedObjectsManager);
            }
            if (visitor instanceof BugFinderSynthesizedObjectsManagerAwareVisitor) {
                bfVisitor = (BugFinderSynthesizedObjectsManagerAwareVisitor)visitor;
                bfVisitor.setSynthesizedObjectsManager(synthesizedObjectsManager);
            }
            if (visitor instanceof BugFinderClocksAwareVisitor) {
                bfVisitor = (BugFinderClocksAwareVisitor)visitor;
                bfVisitor.setClocks(clocks);
            }
            if (visitor instanceof BugFinderResetsAwareVisitor) {
                bfVisitor = (BugFinderResetsAwareVisitor)visitor;
                bfVisitor.setResets(resets);
            }
            if (visitor instanceof BugFinderEnablesAwareVisitor) {
                bfVisitor = (BugFinderEnablesAwareVisitor)visitor;
                bfVisitor.setEnables(enables);
            }
            if (!(visitor instanceof BugFinderFsmsAwareVisitor)) continue;
            bfVisitor = (BugFinderFsmsAwareVisitor)visitor;
            bfVisitor.setFsms(fsms);
        }
    }

    private void injectTreeFilesIntoVisitors(Set<VhdlCheck> checks) {
        LOG.info("Injecting TreeFile data into visitors...");
        for (Visitor visitor : checks) {
            TreeFileAwareVisitor tfVisitor;
            if (visitor instanceof TopEntityTreeFileAwareVisitor) {
                tfVisitor = (TopEntityTreeFileAwareVisitor)((Object)visitor);
                Optional topModuleProperty = this.config.get("sonar.hdl.topModule");
                if (topModuleProperty.isPresent()) {
                    tfVisitor.setTopEntity(this.treeFileVisitor.get(EntityTreeFile.class).stream().filter(e -> ((EntityDeclarationTree)e.tree()).identifier().text().equalsIgnoreCase((String)topModuleProperty.get())).findFirst().orElse(null));
                }
            }
            if (visitor instanceof DesignFileTreeFileAwareVisitor) {
                tfVisitor = (DesignFileTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setDesignFile(this.treeFileVisitor.get(DesignFileTreeFile.class));
            }
            if (visitor instanceof ProcessTreeFileAwareVisitor) {
                tfVisitor = (ProcessTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setProcesses(this.treeFileVisitor.get(ProcessTreeFile.class));
            }
            if (visitor instanceof ArchitectureTreeFileAwareVisitor) {
                tfVisitor = (ArchitectureTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setArchitectures(this.treeFileVisitor.get(ArchitectureTreeFile.class));
            }
            if (visitor instanceof ConfigurationTreeFileAwareVisitor) {
                tfVisitor = (ConfigurationTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setConfigurations(this.treeFileVisitor.get(ConfigurationTreeFile.class));
            }
            if (visitor instanceof ComponentDeclarationTreeFileAwareVisitor) {
                tfVisitor = (ComponentDeclarationTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setComponentDeclarations(this.treeFileVisitor.get(ComponentTreeFile.class));
            }
            if (visitor instanceof ConstantTreeFileAwareVisitor) {
                tfVisitor = (ConstantTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setConstants(this.treeFileVisitor.get(ConstantTreeFile.class));
            }
            if (visitor instanceof EntityTreeFileAwareVisitor) {
                tfVisitor = (EntityTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setEntities(this.treeFileVisitor.get(EntityTreeFile.class));
            }
            if (visitor instanceof ComponentInstantiationStatementTreeFileAwareVisitor) {
                tfVisitor = (ComponentInstantiationStatementTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setComponentInstantiationStatements(this.treeFileVisitor.get(ComponentInstantiationTreeFile.class));
            }
            if (visitor instanceof FunctionTreeFileAwareVisitor) {
                tfVisitor = (FunctionTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setFunctions(this.treeFileVisitor.get(FunctionTreeFile.class));
            }
            if (visitor instanceof PackageTreeFileAwareVisitor) {
                tfVisitor = (PackageTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setPackages(this.treeFileVisitor.get(PackageTreeFile.class));
            }
            if (visitor instanceof PackageBodyTreeFileAwareVisitor) {
                tfVisitor = (PackageBodyTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setPackageBodies(this.treeFileVisitor.get(PackageBodyTreeFile.class));
            }
            if (visitor instanceof ProcedureTreeFileAwareVisitor) {
                tfVisitor = (ProcedureTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setProcedures(this.treeFileVisitor.get(ProcedureTreeFile.class));
            }
            if (visitor instanceof SignalTreeFileAwareVisitor) {
                tfVisitor = (SignalTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setSignals(this.treeFileVisitor.get(SignalTreeFile.class));
            }
            if (visitor instanceof VariableTreeFileAwareVisitor) {
                tfVisitor = (VariableTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setVariables(this.treeFileVisitor.get(VariableTreeFile.class));
            }
            if (visitor instanceof TypeTreeFileAwareVisitor) {
                tfVisitor = (TypeTreeFileAwareVisitor)((Object)visitor);
                tfVisitor.setTypes(this.treeFileVisitor.get(TypeTreeFile.class));
            }
            if (!(visitor instanceof SubtypeTreeFileAwareVisitor)) continue;
            tfVisitor = (SubtypeTreeFileAwareVisitor)((Object)visitor);
            tfVisitor.setSubtypes(this.treeFileVisitor.get(SubtypeTreeFile.class));
        }
        LOG.info("Injecting TreeFile data into visitors: Done");
    }

    private void saveSingleFileIssues(List<IssueInterface> issues) {
        LOG.info("Saving single-file issues...");
        this.issueSaver.saveIssues(issues);
        LOG.info("Saving single-file issues: Done");
    }

    private void saveCrossFilesIssues(Set<Check> check2) {
        LOG.info("Saving cross-file issues...");
        CrossFileIssueSaver.saveIssues(check2, this.issueSaver);
        LOG.info("Saving cross-file issues: Done");
    }

    private VhdlFileTreeTuple parseFile(File file) {
        try {
            return new VhdlFileTreeTuple(file, (DesignFileTree)this.parser.parse(file));
        }
        catch (RecognitionException e) {
            LOG.error("Unable to parse file: {}\n{}", (Object)FileUtils.sanitizedPath(file.getAbsolutePath()), (Object)e.getMessage());
            this.createIssueIfParsingErrorCheckIsActivated(e, file);
            return null;
        }
    }

    private Set<Check> getCrossFileChecks(Set<VhdlCheck> vhdlChecks) {
        return vhdlChecks.stream().filter(CrossFileCheck.class::isInstance).collect(Collectors.toSet());
    }

    private List<IssueInterface> scanFile(File file, DesignFileTree tree, List<TreeVisitor<VhdlTree>> visitors) {
        FileScannerContext<DesignFileTree> context = new FileScannerContext<DesignFileTree>(tree, file, this.config);
        ArrayList<IssueInterface> issues = new ArrayList<IssueInterface>();
        for (TreeVisitor<VhdlTree> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                CharsetAwareVisitor charsetAwareVisitor = (CharsetAwareVisitor)((Object)visitor);
                charsetAwareVisitor.setCharset(this.charset);
            }
            if (visitor instanceof SingleFileCheck) {
                SingleFileCheck c = (SingleFileCheck)((Object)visitor);
                issues.addAll(c.scanFile(context).allIssues());
                continue;
            }
            visitor.scanTree(context);
        }
        return issues;
    }

    private void setParsingErrorCheckIfActivated(Set<VhdlCheck> checks) {
        for (VhdlCheck check2 : checks) {
            ParsingErrorCheck errorCheck;
            if (!(check2 instanceof ParsingErrorCheck)) continue;
            this.parsingErrorCheck = errorCheck = (ParsingErrorCheck)check2;
            break;
        }
    }

    private void createIssueIfParsingErrorCheckIsActivated(RecognitionException e, File file) {
        if (this.parsingErrorCheck != null) {
            this.issueSaver.saveIssue(new LineIssue(this.parsingErrorCheck, file, e.getLine(), e.getMessage()));
        }
    }

    private Set<BugFinderVisitor> vhdlBugFinderVisitors(Set<VhdlCheck> vhdlChecks) {
        return vhdlChecks.stream().filter(BugFinderVisitor.class::isInstance).map(BugFinderVisitor.class::cast).collect(Collectors.toSet());
    }
}

