/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.sonar.plugins.BugFinderSensor;
import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.hdl.measures.YosysMetricsImporter;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"yosys-metrics"})
@DependsUpon(value={"bug-finder"})
public class YosysMetricSensor
implements Sensor {
    private final Configuration config;
    private final BugFinderSensor bugFinderSensor;

    public YosysMetricSensor(Configuration config, BugFinderSensor bugFinderSensor) {
        this.config = config;
        this.bugFinderSensor = bugFinderSensor;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Yosys Metrics").onlyOnLanguages(new String[]{"vhdl", "verilog", "hdl"});
    }

    public void execute(SensorContext context) {
        if (!Product.hdlDesigner(context) && Product.bugFinder(this.config)) {
            YosysMetricsImporter yosysMetricsImporter = new YosysMetricsImporter(context);
            yosysMetricsImporter.setCustomMetrics(this.bugFinderSensor.bugFinderOutput().customMetrics);
            yosysMetricsImporter.saveMetrics();
        }
    }
}

