/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.bugfinder.yosys;

import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.config.Configuration;

public class YosysSetParameters {
    private final Set<String> setParameters;

    public YosysSetParameters(Configuration config) {
        String projectBaseDir = (String)config.get("sonar.projectBaseDir").get();
        String hierarchyScriptAsString = (String)config.get("sonar.bugfinder.hierarchyScriptPath").get();
        Path hierarchyScriptPath = Paths.get(projectBaseDir + File.separator + hierarchyScriptAsString, new String[0]);
        this.setParameters = this.retrieveHierarchyParameters(hierarchyScriptPath);
    }

    public Set<String> setParameters() {
        return this.setParameters;
    }

    private Set<String> retrieveHierarchyParameters(Path hierarchyScriptPath) {
        HashSet<String> params = new HashSet<String>();
        try (Stream<String> lines = Files.lines(hierarchyScriptPath);){
            for (String line : lines.toList()) {
                if (!line.trim().startsWith("hierarchy")) continue;
                String[] chparam = line.trim().split("-chparam");
                for (int i = 1; i < chparam.length; ++i) {
                    String[] chparamSplit = chparam[i].split("\\s+");
                    params.add(chparamSplit[1].toLowerCase());
                    params.add(chparamSplit[2].toLowerCase());
                }
                break;
            }
        }
        catch (IOException e) {
            throw new LintyException("Cannot read file: " + FileUtils.sanitizedPath(hierarchyScriptPath.toAbsolutePath().toString()), e);
        }
        return params;
    }
}

