/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.GraphUtils;
import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.clock.CDCs;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysCDC;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.sonar.api.config.Configuration;

public class CDCsReport
extends Report {
    private final CDCs cdcs;

    public CDCsReport(CDCs cdcs, Configuration config) {
        super(config);
        this.cdcs = cdcs;
    }

    @Override
    public String fileName() {
        return "clock_domain_crossings.md";
    }

    @Override
    public String title() {
        return "Clock Domain Crossings (CDC)";
    }

    @Override
    public String summary() {
        return "CDCs: " + this.cdcs.size();
    }

    @Override
    public void generate() {
        this.generateMainReport();
        String bugfinderDir = this.bugfinderDir() + File.separator + "cdcs";
        String reportDir = this.reportsDir() + File.separator + "cdcs";
        new File(reportDir).mkdirs();
        this.createLintyGraph(bugfinderDir, reportDir);
        this.updateAndMoveGraphs();
        this.generateHtmlPagesForDotGraphs();
        this.generateDetailedReports();
    }

    private void generateMainReport() {
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(this.cdcs.size()).append("**\n\n");
        if (this.cdcs.size() > 0) {
            data.append("|ID|Graph|Origin Flip-flop|Target Flip-flop|Details|\n").append("|---:|:---:|---|---|:---:|\n");
            for (YosysCDC cdc : this.cdcs.cdcs()) {
                data.append("|").append(cdc.id()).append("|").append(this.linkToGraph("Open CDC Graph", "cdcs/cdc_" + cdc.id())).append("|");
                String originClockDomainDisplay = cdc.origin().clockDomainUsage().clockDomain().name() + " (" + cdc.origin().clockDomainUsage().direction().value() + ")";
                data.append("Signal: `").append(String.join((CharSequence)"`, `", cdc.origin().qPublicNames())).append("`").append("<br>").append("Clock domain: ").append(cdc.origin().clockDomainUsage().clockDomain().location().markdown(originClockDomainDisplay)).append("|");
                String targetClockDomainDisplay = cdc.target().clockDomainUsage().clockDomain().name() + " (" + cdc.target().clockDomainUsage().direction().value() + ")";
                data.append("Signal: `").append(String.join((CharSequence)"`, `", cdc.target().qPublicNames())).append("`").append("<br>").append("Clock domain: ").append(cdc.target().clockDomainUsage().clockDomain().location().markdown(targetClockDomainDisplay)).append("|").append(this.linkToDetails("View CDC Details", "cdcs/cdc_" + cdc.id() + ".md")).append("|\n");
            }
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void generateDetailedReports() {
        for (YosysCDC cdc : this.cdcs.cdcs()) {
            this.generateDetailedReport(cdc);
        }
    }

    private void generateDetailedReport(YosysCDC cdc) {
        String header = "|Graph|Signal|Clock Domain|Flip-flop|\n|:---:|---|---|---|\n";
        StringBuilder data = new StringBuilder().append("# CDC #").append(cdc.id()).append("\n\n").append("## Origin Flip-flop\n\n").append(header).append("|").append(this.linkToGraph("Open CDC Graph", "cdcs/cdc_" + cdc.id())).append("|");
        String originClockDomainDisplay = cdc.origin().clockDomainUsage().clockDomain().name() + " (" + cdc.origin().clockDomainUsage().direction().value() + ")";
        data.append("Signal: `").append(String.join((CharSequence)"`, `", cdc.origin().qPublicNames())).append("`").append("<br>Usage:<br>- ").append(this.cdcs.dcUtils().signalsToMarkdown(cdc.origin())).append("|").append(cdc.origin().clockDomainUsage().clockDomain().location().markdown(originClockDomainDisplay)).append("|").append(cdc.origin().cell().scopes() != null ? cdc.origin().cell().scopes().instantiationPathAsMarkdown() : "").append(" > ").append(cdc.origin().cell().location().markdown()).append("|\n\n\n").append("## Target Flip-flop\n\n").append(header).append("|").append(this.linkToGraph("Open CDC Graph", "cdcs/cdc_" + cdc.id())).append("|");
        String targetClockDomainDisplay = cdc.target().clockDomainUsage().clockDomain().name() + " (" + cdc.target().clockDomainUsage().direction().value() + ")";
        data.append("Signal: `").append(String.join((CharSequence)"`, `", cdc.target().qPublicNames())).append("`").append("<br>Usage:<br>- ").append(this.cdcs.dcUtils().signalsToMarkdown(cdc.target())).append("|").append(cdc.target().clockDomainUsage().clockDomain().location().markdown(targetClockDomainDisplay)).append("|").append(cdc.target().cell().scopes() != null ? cdc.target().cell().scopes().instantiationPathAsMarkdown() : "").append(" > ").append(cdc.target().cell().location().markdown()).append("|\n");
        this.writeMainReport(this.addBackLinks(data.toString(), "[Back to CDC Report](../clock_domain_crossings.md)"), "cdcs/cdc_" + cdc.id() + ".md");
    }

    private void createLintyGraph(String sourceDirPath, String destinationDirPath) {
    }

    private void updateAndMoveGraphs() {
        Path bugFinderGraphPath = Path.of(this.bugfinderDir() + File.separator + "cdcs", new String[0]);
        Path reportGraphPath = Path.of(this.graphsDir() + "/cdcs", new String[0]);
        if (bugFinderGraphPath.toFile().exists()) {
            CDCsReport.rewriteGraphs(bugFinderGraphPath);
            try {
                Files.move(bugFinderGraphPath, reportGraphPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new LintyException("Cannot move " + String.valueOf(bugFinderGraphPath) + " to " + String.valueOf(reportGraphPath), e);
            }
        }
    }

    private static void rewriteGraphs(Path path) {
        GraphUtils.rewriteYosysGraphs(path, "cdc_", "CDC");
    }

    private void generateHtmlPagesForDotGraphs() {
        File[] files;
        File cdcsDir = new File(this.graphsDir() + "/cdcs");
        for (File file : files = cdcsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".dot"))) {
            this.writeDotGraph(file.getName().substring(0, file.getName().length() - ".dot".length()), "cdcs");
        }
    }
}

