/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.clock.graph.ClockHierarchyGraph;
import com.lintyservices.sonar.plugins.hdl.clock.graph.InstanceForClockHierarchyGraph;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.DesignHierarchy;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.ClockAndResetDomainUtils;
import com.lintyservices.yosys.objects.YosysClockDomain;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import com.lintyservices.yosys.objects.YosysScopes;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public class ClockDomainsReport
extends Report {
    private final ClockDomains clockDomains;
    private final DesignHierarchy designHierarchy;
    private final Set<File> filesToAnalyze;
    private final ClockAndResetDomainUtils clockAndResetDomainUtils;
    @Nullable
    private final YosysClockManagementModule cmm;

    public ClockDomainsReport(ClockDomains clockDomains, DesignHierarchy designHierarchy, Set<File> filesToAnalyze, HdlIssueLocation topModuleLocation, Configuration config) {
        super(config);
        this.clockDomains = clockDomains;
        this.designHierarchy = designHierarchy;
        this.filesToAnalyze = filesToAnalyze;
        this.cmm = clockDomains.clockManagementModule();
        this.clockAndResetDomainUtils = new ClockAndResetDomainUtils(filesToAnalyze, topModuleLocation, config);
    }

    @Override
    public String fileName() {
        return "clock_domains.md";
    }

    @Override
    public String title() {
        return "Clock Domains";
    }

    @Override
    public String summary() {
        return "Clock domains: " + this.clockDomains.size();
    }

    @Override
    public void generate() {
        this.generateMainReport();
        new File(this.reportsDir() + File.separator + "clock_domains").mkdirs();
        this.generateDetailedReports();
        this.generateClockHierarchyGraph();
    }

    private void generateMainReport() {
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("## Clock Management Module (CMM)\n\n");
        if (this.cmm != null && this.cmm.isCmm(this.filesToAnalyze)) {
            data.append("**").append(this.cmm.moduleLocation().markdown(this.cmm.moduleName())).append("** instantiated as **").append(this.cmm.instanceLocation().markdown(this.cmm.instanceName())).append("**");
        } else {
            data.append("None identified.");
        }
        data.append("\n\n<br>\n\n*All clocks should be generated within a unique clock management module (CMM).*\n").append("*A dedicated CMM brings a lot in terms of reuse and portability. ").append("Because all vendor-specific clock elements are generated within the same module, ").append("it is easier to replace this module to target other FPGAs.*\n\n").append("\n\n").append("## ").append(this.title()).append("\n\n").append("Count: **").append(this.clockDomains.size()).append("**\n\n");
        if (this.clockDomains.size() > 0) {
            data.append("| Name: Origin | Graph | Rising | Falling | Details |\n").append("| --- | :---: | :---: | :---: | :---: |\n").append(this.clockDomainsAsMarkDown(this.clockDomains.clockDomains())).append("\n\n").append("*A clock domain used for both rising and falling edges is counted as two separate clock domains.*\n\n");
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void generateClockHierarchyGraph() {
        this.writeGraph(new ClockHierarchyGraph(new InstanceForClockHierarchyGraph(this.designHierarchy.top(), this.clockDomains.clockDomains())), "clock_hierarchy");
    }

    private String clockDomainsAsMarkDown(List<YosysClockDomain> clockDomains) {
        StringBuilder data = new StringBuilder();
        int index = 1;
        for (YosysClockDomain domain : clockDomains) {
            data.append("|");
            Map<String, HdlIssueLocation> originLocations = this.clockAndResetDomainUtils.originLocationsAsMap(domain);
            if (originLocations.size() > 1) {
                data.append("**Complex:** ");
            }
            data.append("**").append(domain.location() != null ? domain.location().markdown(domain.name()) : "").append("**");
            for (String key : originLocations.keySet().stream().sorted().toList()) {
                data.append("<br>&nbsp;&nbsp;-&nbsp;").append("**").append(key).append("**: ").append(originLocations.get(key).markdownWithLocationDisplay(this.config(), originLocations.get(key).message().replace(" origin", "").replaceAll("Port:.+", "Port")));
            }
            data.append("|").append(this.linkToGraph("Open Clock Hierarchy Graph", "clock_hierarchy")).append("|").append(this.asCheckmark(domain.rising())).append("|").append(this.asCheckmark(domain.falling())).append("|").append(this.linkToDetails("View Clock Domain Details", "clock_domains/clock_domain_" + index + ".md")).append("|\n");
            ++index;
        }
        return data.toString();
    }

    private void generateDetailedReports() {
        int idIndex = 1;
        for (YosysClockDomain domain : this.clockDomains.clockDomains()) {
            this.generateDetailedReport(domain, idIndex);
            ++idIndex;
        }
    }

    private void generateDetailedReport(YosysClockDomain domain, int idIndex) {
        Map<String, HdlIssueLocation> originLocations = this.clockAndResetDomainUtils.originLocationsAsMap(domain);
        StringBuilder data = new StringBuilder().append("# Clock Domain Details\n\n").append("## Summary\n\n").append("| Name: Origin | Graph | Rising | Falling | Number of flip-flops<br>using this clock domain | Number of instances<br>using this clock domain |\n").append("| --- | :---: | :---: | :---: | ---: | ---: |\n").append("|");
        if (originLocations.size() > 1) {
            data.append("**Complex:** ");
        }
        data.append("**").append(domain.location() != null ? domain.location().markdown(domain.name()) : "").append("**");
        for (String key : originLocations.keySet().stream().sorted().toList()) {
            data.append("<br>&nbsp;&nbsp;-&nbsp;").append("**").append(key).append("**: ").append(originLocations.get(key).markdownWithLocationDisplay(this.config(), originLocations.get(key).message().replace(" origin", "").replaceAll("Port:.+", "Port")));
        }
        data.append("|").append(this.linkToGraph("Open Clock Hierarchy Graph", "clock_hierarchy")).append("|").append(this.asCheckmark(domain.rising())).append("|").append(this.asCheckmark(domain.falling())).append("|**").append(domain.flipFlops()).append("**/").append(Math.round(100.0 * (double)domain.flipFlops().intValue() / domain.percentageFlipFlops())).append(" (").append(String.format("%.02f", domain.percentageFlipFlops())).append("%)").append("|**").append(domain.modules()).append("**/").append(this.designHierarchy.numberOfInstances()).append("|\n").append("\n\n").append(this.instancesUsingClockDomain(domain)).append("\n\n").append("## Flip-flops using this clock domain\n\n").append("**Count: ").append(domain.flipFlops()).append("**\n\n").append("### Rising-edge usage\n\n").append("| Count: ").append(domain.risingFFs().size()).append(" |\n").append("| --- |\n").append(this.toLocationMarkdown(domain.risingFFs())).append("\n\n").append("### Falling-edge usage\n\n").append("| Count: ").append(domain.fallingFFs().size()).append(" |\n").append("| --- |\n").append(this.toLocationMarkdown(domain.fallingFFs())).append("\n\n<br>\n\n").append("Note that there could be fewer source code locations than the number of flip-flops ").append("because several flip-flops can be inferred from the same piece of code.").append("<br>\n<br>\n\n");
        this.writeMainReport(this.addBackLinks(data.toString(), "[Back to Clock Domains Report](../clock_domains.md)"), "clock_domains/clock_domain_" + idIndex + ".md");
    }

    private String instancesUsingClockDomain(YosysClockDomain domain) {
        Set rising = domain.usedInInstancesRising().stream().map(YosysScopes::instantiationPathAsMarkdown).collect(Collectors.toSet());
        Set falling = domain.usedInInstancesFalling().stream().map(YosysScopes::instantiationPathAsMarkdown).collect(Collectors.toSet());
        HashSet all = new HashSet();
        all.addAll(rising);
        all.addAll(falling);
        List sortedInstances = all.stream().sorted().toList();
        StringBuilder markdown = new StringBuilder().append("## Instances using this clock domain\n\n").append("**Count: ").append(all.size()).append("**\n\n").append("| Instance | Rising | Falling |\n").append("| --- | :---: | :---: |\n");
        for (String instance : sortedInstances) {
            markdown.append("|").append(instance).append("|").append(this.asCheckmark(rising.contains(instance))).append("|").append(this.asCheckmark(falling.contains(instance))).append("|\n");
        }
        return markdown.toString();
    }
}

