/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.GraphUtils;
import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.combinationalloop.CombinationalLoops;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysCombinationalLoop;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.sonar.api.config.Configuration;

public class CombinationalLoopsReport
extends Report {
    private final CombinationalLoops loops;

    public CombinationalLoopsReport(CombinationalLoops loops, Configuration config) {
        super(config);
        this.loops = loops;
    }

    @Override
    public String fileName() {
        return "combinational_loops.md";
    }

    @Override
    public String title() {
        return "Combinational Loops";
    }

    @Override
    public String summary() {
        return "Loops: " + this.loops.size();
    }

    @Override
    public void generate() {
        this.generateMainReport();
        String bugfinderDir = this.bugfinderDir() + File.separator + "combinational_loops";
        String reportDir = this.reportsDir() + File.separator + "combinational_loops";
        new File(reportDir).mkdirs();
        this.createLintyGraph(bugfinderDir, reportDir);
        this.updateAndMoveGraphs();
        this.generateHtmlPagesForDotGraphs();
    }

    private void generateMainReport() {
        int numberOfLoops = this.loops.size();
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(numberOfLoops).append("**\n\n");
        if (numberOfLoops > 0) {
            data.append("|ID|Graph|Signal|\n").append("|---|:---:|---|\n");
            for (YosysCombinationalLoop loop : this.loops.combinationalLoops()) {
                data.append("|").append(loop.id()).append("|").append(this.linkToGraph("Open Combinational Loop Graph", "combinational_loops/combinational_loop_" + loop.id())).append("|").append(loop.signal().name()).append(": ").append(loop.signal().location().markdown()).append("|`").append("\n");
            }
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void createLintyGraph(String sourceDirPath, String destinationDirPath) {
    }

    private void updateAndMoveGraphs() {
        Path bugFinderGraphPath = Path.of(this.bugfinderDir() + File.separator + "combinational_loops", new String[0]);
        Path reportGraphPath = Path.of(this.graphsDir() + "/combinational_loops", new String[0]);
        if (bugFinderGraphPath.toFile().exists()) {
            CombinationalLoopsReport.rewriteGraphs(bugFinderGraphPath);
            try {
                Files.move(bugFinderGraphPath, reportGraphPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new LintyException("Cannot move " + String.valueOf(bugFinderGraphPath) + " to " + String.valueOf(reportGraphPath), e);
            }
        }
    }

    private static void rewriteGraphs(Path path) {
        GraphUtils.rewriteYosysGraphs(path, "combinational_loop_", "Combinational Loop");
    }

    private void generateHtmlPagesForDotGraphs() {
        File[] files;
        File loopDir = new File(this.graphsDir() + "/combinational_loops");
        for (File file : files = loopDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".dot"))) {
            this.writeDotGraph(file.getName().substring(0, file.getName().length() - ".dot".length()), "combinational_loops");
        }
    }
}

