/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.slang.trees.DesignUnitDeclaration;
import com.lintyservices.slang.trees.InterfaceDeclaration;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.slang.trees.PackageDeclaration;
import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.DesignHierarchy;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Instance;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Parameter;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.graph.DesignHierarchyGraph;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.graph.InstanceForDesignHierarchyGraph;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.PackageTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceSignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.MultipleDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationFunctionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationProcedureTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.sonar.api.config.Configuration;

public class DesignHierarchyReport
extends Report {
    private final DesignHierarchy designHierarchy;
    private final File projectBaseDir = new File((String)this.config().get("sonar.projectBaseDir").get());
    private final List<EntityTreeFile> vhdlEntities;
    private final List<PackageTreeFile> vhdlPackages;
    private final List<ModuleDeclaration> verilogModules;
    private final List<PackageDeclaration> verilogPackages;
    private final List<InterfaceDeclaration> verilogInterfaces;

    public DesignHierarchyReport(DesignHierarchy designHierarchy, Set<EntityTreeFile> vhdlEntities, Set<PackageTreeFile> vhdlPackages, List<ModuleDeclaration> verilogModules, List<PackageDeclaration> verilogPackages, List<InterfaceDeclaration> verilogInterfaces, Configuration config) {
        super(config);
        this.designHierarchy = designHierarchy;
        this.vhdlEntities = vhdlEntities.stream().sorted(Comparator.comparing(e -> ((EntityDeclarationTree)e.tree()).identifier().text()).thenComparing(e -> e.location().markdown(this.config()))).toList();
        this.vhdlPackages = vhdlPackages.stream().sorted(Comparator.comparing(p -> ((PackageDeclarationTree)p.tree()).identifier().text()).thenComparing(p -> p.location().markdown(this.config()))).toList();
        this.verilogModules = verilogModules.stream().sorted(Comparator.comparing(m -> m.identifier().text()).thenComparing(m -> m.location().markdown(this.projectBaseDir))).toList();
        this.verilogPackages = verilogPackages.stream().sorted(Comparator.comparing(p -> p.identifier().text()).thenComparing(p -> p.location().markdown(this.projectBaseDir))).toList();
        this.verilogInterfaces = verilogInterfaces.stream().sorted(Comparator.comparing(i -> i.identifier().text()).thenComparing(i -> i.location().markdown(this.projectBaseDir))).toList();
    }

    @Override
    public String fileName() {
        return "design_hierarchy.md";
    }

    @Override
    public String title() {
        return "Design Hierarchy";
    }

    @Override
    public String summary() {
        return "Modules: " + this.designHierarchy.numberOfModules() + "<br>Instantiations: " + this.designHierarchy.numberOfInstances();
    }

    @Override
    public void generate() {
        String baseDirectory = this.reportsDir() + File.separator + "design";
        new File(baseDirectory).mkdirs();
        this.generateMainReport();
        this.generateDetailedModuleReports();
        this.generateDetailedPackageReports();
        this.generateDesignGraph();
    }

    private void generateMainReport() {
        String data = "# " + this.title() + "\n\n## Summary\n\n| Hierarchy | Modules | Instantiations |\n| :---: | --- | --- |\n| " + this.linkToGraph("Open Design Hierarchy Graph", "design_hierarchy") + " | " + this.designHierarchy.numberOfModules() + " | " + this.designHierarchy.numberOfInstances() + " |\n\n\n## Dependencies\n\nProperly architecture your design to tend to a highly hierarchical design. Modules that instantiate too many other modules have likely too many responsibilities.\n\n| Instance | Modules | Instantiations |\n| --- | --- | --- |\n" + this.generateInstanceDependencies() + "\n\nNote that instantiations from blackboxes or third-party IPs are not listed in this report.\n\n" + this.modulesReport() + "\n\n" + this.packagesReport() + "\n\n" + this.interfacesReport();
        this.writeMainReport(data, this.fileName());
    }

    private void generateDesignGraph() {
        this.writeGraph(new DesignHierarchyGraph(new InstanceForDesignHierarchyGraph(this.designHierarchy.top())), "design_hierarchy");
    }

    private String generateInstanceDependencies() {
        StringBuilder data = new StringBuilder();
        this.designHierarchy.allInstances().stream().filter(i -> !i.isThirdParty()).sorted(Comparator.comparing(i -> ((Instance)i).instantiatedModulesInSourceCode().size(), Comparator.reverseOrder()).thenComparing(i -> ((Instance)i).name()).thenComparing(i -> ((Instance)i).location().toString())).forEach(dependency -> {
            data.append("|").append(dependency.locationAsMarkdown()).append("|");
            List<String> instantiatedModules = dependency.instantiatedModulesInSourceCode().stream().filter(m -> m.location() != null).map(m -> m.location().markdown(m.name())).sorted().toList();
            if (!instantiatedModules.isEmpty()) {
                data.append("Count: ").append(instantiatedModules.size()).append("<br>").append(String.join((CharSequence)"<br>", instantiatedModules));
            }
            data.append("|");
            Set<Instance> instantiating = dependency.instantiatesFromSourceCode();
            if (!instantiating.isEmpty()) {
                data.append("Count: ").append(instantiating.size()).append("<br>");
                for (Instance child : instantiating.stream().filter(i -> !i.isThirdParty()).sorted(Comparator.comparingInt(i -> i.location().beginLine())).sorted(Comparator.comparing(Instance::name)).toList()) {
                    data.append(child.location().markdown(child.name())).append(": ").append(child.module().location().markdown(child.module().name()));
                    String architectureName = child.module().architectureName();
                    if (architectureName != null) {
                        data.append(" (").append(child.module().architectureLocation().markdown(architectureName)).append(")");
                    }
                    data.append("<br>");
                }
            }
            data.append("|\n");
        });
        return data.toString();
    }

    private String modulesReport() {
        StringBuilder data = new StringBuilder();
        int index = 1;
        if (!this.vhdlEntities.isEmpty()) {
            data.append("## VHDL Entities\n\n").append("Count: ").append(this.vhdlEntities.size()).append("\n\n").append("| Name | Location | Description | Details |\n").append("| --- | --- | --- | :---: |\n");
            for (EntityTreeFile entity : this.vhdlEntities) {
                data.append("|").append(((EntityDeclarationTree)entity.tree()).identifier().text()).append("|").append(entity.location().markdown(this.config())).append("|").append(DesignHierarchyReport.sanitizeDescription(((EntityDeclarationTree)entity.tree()).doxygenComments())).append("|").append(this.linkToDetails("View VHDL Entity Details", "design/module_" + index + ".md")).append("|\n");
                ++index;
            }
        }
        if (!this.verilogModules.isEmpty()) {
            data.append("## Verilog Modules\n\n").append("Count: ").append(this.verilogModules.size()).append("\n\n").append("| Name | Location | Description | Details |\n").append("| --- | --- | --- | :---: |\n");
            for (ModuleDeclaration module : this.verilogModules) {
                data.append("|").append(module.identifier().text()).append("|").append(module.location().markdown(this.projectBaseDir)).append("|").append(DesignHierarchyReport.sanitizeDescription(module.doxygenComments())).append("|").append(this.linkToDetails("View Verilog Module Details", "design/module_" + index + ".md")).append("|\n");
                ++index;
            }
        }
        return data.toString();
    }

    private void generateDetailedModuleReports() {
        int moduleId = 1;
        for (EntityTreeFile entity : this.vhdlEntities) {
            new File(this.reportsDir() + File.separator + "design" + File.separator + "module_" + moduleId).mkdirs();
            this.generateDetailedEntityReport(entity, moduleId);
            ++moduleId;
        }
        for (ModuleDeclaration module : this.verilogModules) {
            new File(this.reportsDir() + File.separator + "design" + File.separator + "module_" + moduleId).mkdirs();
            this.generateDetailedModuleReport(module, moduleId);
            ++moduleId;
        }
    }

    private void generateDetailedEntityReport(EntityTreeFile entity, int moduleId) {
        StringBuilder data = new StringBuilder().append("# Entity - ").append(((EntityDeclarationTree)entity.tree()).identifier().text()).append("\n\n").append("## Summary\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n").append("|").append(((EntityDeclarationTree)entity.tree()).identifier().text()).append("|").append(entity.location().markdown(this.config())).append("|").append(DesignHierarchyReport.sanitizeDescription(((EntityDeclarationTree)entity.tree()).doxygenComments())).append("|\n").append("## Instantiations\n\n");
        List<Instance> instances = this.designHierarchy.allInstances().stream().filter(i -> i.matchingEntity() != null && i.matchingEntity().equals(entity)).sorted(Comparator.comparing(Instance::locationAsMarkdown)).toList();
        data.append("Count: ").append(instances.size());
        if (!instances.isEmpty()) {
            data.append("\n\n").append("| Name | Location | Description | Details |\n").append("| --- | --- | --- | :---: |\n");
            int instantiationId = 1;
            for (Instance instantiation : instances) {
                data.append("| ").append(instantiation.name()).append(" | ").append(instantiation.location().markdown()).append(" | ").append(DesignHierarchyReport.sanitizeDescription(instantiation.doxygenComments())).append(" | ").append(this.linkToDetails("View Instantiation Details", "module_" + moduleId + "/instantiation_" + instantiationId + ".md")).append(" |\n");
                this.generateDetailedInstantiationReport(instantiationId, instantiation, moduleId);
                ++instantiationId;
            }
        }
        data.append("\n\n").append("## Generics\n\n").append("Count: ").append(((EntityDeclarationTree)entity.tree()).genericIdentifiers().size()).append("\n\n");
        if (!((EntityDeclarationTree)entity.tree()).genericIdentifiers().isEmpty()) {
            data.append("| Name | Type | Default value | Description |\n").append("| --- | --- | --- | --- |\n");
            for (InterfaceDeclarationTree generic : ((EntityDeclarationTree)entity.tree()).generics()) {
                for (IdentifierTree identifier : generic.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(entity.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(generic.type().toStringWithWhitespaceBetweenEachTree()).append("|");
                    if (generic instanceof InterfaceSignalDeclarationTree && ((InterfaceSignalDeclarationTree)generic).defaultValue() != null) {
                        data.append(((InterfaceSignalDeclarationTree)generic).defaultValue());
                    }
                    data.append("|").append(DesignHierarchyReport.sanitizeDescription(generic.doxygenComments())).append("|\n");
                }
            }
        }
        data.append("## Ports\n\n").append("Count: ").append(((EntityDeclarationTree)entity.tree()).portIdentifiers().size()).append("\n\n");
        if (!((EntityDeclarationTree)entity.tree()).portIdentifiers().isEmpty()) {
            data.append("| Name | Mode | Type | Description |\n").append("| --- | --- | --- | --- |\n");
            for (InterfaceDeclarationTree port : ((EntityDeclarationTree)entity.tree()).ports()) {
                for (IdentifierTree identifier : port.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(entity.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(port.mode() != null ? port.mode() : "").append("|").append(port.type().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(port.doxygenComments())).append("|\n");
                }
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Design Hierarchy Report](../design_hierarchy.md#vhdl-entities)"), "design/module_" + moduleId + ".md");
    }

    private void generateDetailedModuleReport(ModuleDeclaration module, int moduleId) {
        StringBuilder data = new StringBuilder().append("# Module - ").append(module.identifier().text()).append("\n\n").append("## Summary\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n").append("|").append(module.identifier().text()).append("|").append(module.location().markdown(this.projectBaseDir)).append("|").append(DesignHierarchyReport.sanitizeDescription(module.doxygenComments())).append("|\n").append("## Instantiations\n\n");
        List<Instance> instances = this.designHierarchy.allInstances().stream().filter(i -> i.matchingModule() != null && i.matchingModule().equals(module)).sorted(Comparator.comparing(Instance::locationAsMarkdown)).toList();
        data.append("Count: ").append(instances.size());
        if (!instances.isEmpty()) {
            data.append("\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n");
            for (Instance instance : instances) {
                data.append("| ").append(instance.name()).append(" | ").append(instance.location().markdown()).append(" | ").append(instance.doxygenComments()).append(" |\n");
            }
        }
        List<DesignUnitDeclaration.Parameter> parameters = module.getParameters().stream().filter(p -> p.parameterDeclaration() != null).toList();
        data.append("\n\n").append("## Parameters\n\n").append("Count: ").append(parameters.size()).append("\n\n");
        if (!parameters.isEmpty()) {
            data.append("| Name | Local? | Type | Description | Default Value |\n").append("| --- | --- | --- | --- | --- |\n");
            for (DesignUnitDeclaration.Parameter parameter : parameters) {
                data.append("|").append(parameter.identifier().location().markdown(parameter.identifier().text(), this.projectBaseDir)).append("|").append(this.asCheckmark(parameter.parameterDeclaration().isLocal())).append("|").append(parameter.parameterDeclaration().dataType() != null ? parameter.parameterDeclaration().dataType().text() : "").append("|").append(DesignHierarchyReport.sanitizeDescription(parameter.parameterDeclaration().doxygenComments())).append("|").append(parameter.value() != null ? parameter.value().text() : "").append("|\n");
            }
        }
        List<DesignUnitDeclaration.Parameter> list = module.getParameters().stream().filter(p -> p.typeParameterDeclaration() != null).toList();
        data.append("\n\n").append("## Type Parameters\n\n").append("Count: ").append(list.size()).append("\n\n");
        if (!list.isEmpty()) {
            data.append("| Name | Description | Default Value |\n").append("| --- | --- | --- |\n");
            for (DesignUnitDeclaration.Parameter typeParameter : list) {
                data.append("|").append(typeParameter.identifier().location().markdown(typeParameter.identifier().text(), this.projectBaseDir)).append("|").append(DesignHierarchyReport.sanitizeDescription(typeParameter.typeParameterDeclaration().doxygenComments())).append("|").append(typeParameter.value() != null ? typeParameter.value().text() : "").append("|\n");
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Design Hierarchy Report](../design_hierarchy.md#verilog-modules)"), "design/module_" + moduleId + ".md");
    }

    private String packagesReport() {
        StringBuilder data = new StringBuilder();
        if (!this.vhdlPackages.isEmpty()) {
            int index = 1;
            data.append("## VHDL Packages\n\n").append("Count: ").append(this.vhdlPackages.size()).append("\n\n").append("| Name | Location | Description | Details |\n").append("| --- | --- | --- | :---: |\n");
            for (PackageTreeFile packageTreeFile : this.vhdlPackages) {
                data.append("|").append(((PackageDeclarationTree)packageTreeFile.tree()).identifier().text()).append("|").append(packageTreeFile.location().markdown(this.config())).append("|").append(DesignHierarchyReport.sanitizeDescription(((PackageDeclarationTree)packageTreeFile.tree()).doxygenComments())).append("|").append(this.linkToDetails("View VHDL Package Details", "design/package_" + index + ".md")).append("|\n");
                ++index;
            }
        }
        if (!this.verilogPackages.isEmpty()) {
            data.append("## Verilog Packages\n\n").append("Count: ").append(this.verilogPackages.size()).append("\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n");
            for (PackageDeclaration packageDeclaration : this.verilogPackages) {
                data.append("|").append(packageDeclaration.identifier().text()).append("|").append(packageDeclaration.location().markdown(this.projectBaseDir)).append("|").append(DesignHierarchyReport.sanitizeDescription(packageDeclaration.doxygenComments())).append("|\n");
            }
        }
        return data.toString();
    }

    private String interfacesReport() {
        StringBuilder data = new StringBuilder();
        if (!this.verilogInterfaces.isEmpty()) {
            data.append("## Verilog Interfaces\n\n").append("Count: ").append(this.verilogInterfaces.size()).append("\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n");
            for (InterfaceDeclaration interfaceDeclaration : this.verilogInterfaces) {
                data.append("|").append(interfaceDeclaration.identifier().text()).append("|").append(interfaceDeclaration.location().markdown(this.projectBaseDir)).append("|").append(DesignHierarchyReport.sanitizeDescription(interfaceDeclaration.doxygenComments())).append("|\n");
            }
        }
        return data.toString();
    }

    private void generateDetailedPackageReports() {
        int packageId = 1;
        for (PackageTreeFile packageDeclaration : this.vhdlPackages) {
            new File(this.reportsDir() + File.separator + "design" + File.separator + "package_" + packageId).mkdirs();
            this.generateDetailedPackageReport(packageDeclaration, packageId);
            ++packageId;
        }
    }

    private void generateDetailedPackageReport(PackageTreeFile packageDeclaration, int packageId) {
        StringBuilder data = new StringBuilder().append("# Package - ").append(((PackageDeclarationTree)packageDeclaration.tree()).identifier().text()).append("\n\n").append("## Summary\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n").append("|").append(((PackageDeclarationTree)packageDeclaration.tree()).identifier().text()).append("|").append(packageDeclaration.location().markdown(this.config())).append("|").append(DesignHierarchyReport.sanitizeDescription(((PackageDeclarationTree)packageDeclaration.tree()).doxygenComments())).append("|\n").append("\n\n").append("## Constants\n\n").append("Count: ");
        long constantCount = ((PackageDeclarationTree)packageDeclaration.tree()).constants().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).count();
        data.append(constantCount).append("\n\n");
        if (constantCount > 0L) {
            data.append("| Name | Type | Default value | Description |\n").append("| --- | --- | --- | --- |\n");
            for (ConstantDeclarationTree constant : ((PackageDeclarationTree)packageDeclaration.tree()).constants().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                for (IdentifierTree identifier : constant.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(constant.subtypeIndication().toStringWithWhitespaceBetweenEachTree()).append("|");
                    if (constant.expression() != null) {
                        data.append(constant.expression().toStringWithWhitespaceBetweenEachTree());
                    }
                    data.append("|").append(DesignHierarchyReport.sanitizeDescription(constant.doxygenComments())).append("|\n");
                }
            }
        }
        data.append("\n\n").append("## Types\n\n").append("Count: ").append(((PackageDeclarationTree)packageDeclaration.tree()).types().size()).append("\n\n");
        if (!((PackageDeclarationTree)packageDeclaration.tree()).types().isEmpty()) {
            data.append("| Name | Definition | Description |\n").append("| --- | --- | --- |\n");
            for (FullTypeDeclarationTree type : ((PackageDeclarationTree)packageDeclaration.tree()).types().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), type.identifier()).markdown(this.config(), type.identifier().text())).append("|").append(type.typeDefinition().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(type.doxygenComments())).append("|\n");
            }
        }
        data.append("\n\n").append("## Subtypes\n\n").append("Count: ").append(((PackageDeclarationTree)packageDeclaration.tree()).subtypes().size()).append("\n\n");
        if (!((PackageDeclarationTree)packageDeclaration.tree()).subtypes().isEmpty()) {
            data.append("| Name | Base type | Description |\n").append("| --- | --- | --- |\n");
            for (SubtypeDeclarationTree subtype : ((PackageDeclarationTree)packageDeclaration.tree()).subtypes().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), subtype.identifier()).markdown(this.config(), subtype.identifier().text())).append("|").append(subtype.subtypeIndication().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(subtype.doxygenComments())).append("|\n");
            }
        }
        data.append("\n\n").append("## Functions\n\n").append("Count: ").append(((PackageDeclarationTree)packageDeclaration.tree()).functions().size()).append("\n\n");
        if (!((PackageDeclarationTree)packageDeclaration.tree()).functions().isEmpty()) {
            data.append("| Name | Returned type | Description | Details |\n").append("| --- | --- | --- | :---: |\n");
            int functionId = 1;
            for (SubprogramSpecificationFunctionTree subprogramSpecificationFunctionTree : ((PackageDeclarationTree)packageDeclaration.tree()).functions().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), subprogramSpecificationFunctionTree.designator()).markdown(this.config(), subprogramSpecificationFunctionTree.designator().toStringWithWhitespaceBetweenEachTree())).append("|").append(subprogramSpecificationFunctionTree.typeMark().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(subprogramSpecificationFunctionTree.doxygenComments())).append("|").append(this.linkToDetails("View Function Details", "package_" + packageId + "/function_" + functionId + ".md")).append("|\n");
                this.generateDetailedFunctionReport(functionId, subprogramSpecificationFunctionTree, packageId, packageDeclaration);
                ++functionId;
            }
        }
        data.append("\n\n").append("## Procedures\n\n").append("Count: ").append(((PackageDeclarationTree)packageDeclaration.tree()).procedures().size()).append("\n\n");
        if (!((PackageDeclarationTree)packageDeclaration.tree()).procedures().isEmpty()) {
            data.append("| Name | Description | Details |\n").append("| --- | --- | :---: |\n");
            int procedureId = 1;
            for (SubprogramSpecificationProcedureTree subprogramSpecificationProcedureTree : ((PackageDeclarationTree)packageDeclaration.tree()).procedures().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), subprogramSpecificationProcedureTree.designator()).markdown(this.config(), subprogramSpecificationProcedureTree.designator().toStringWithWhitespaceBetweenEachTree())).append("|").append(DesignHierarchyReport.sanitizeDescription(subprogramSpecificationProcedureTree.doxygenComments())).append("|").append(this.linkToDetails("View Procedure Details", "package_" + packageId + "/procedure_" + procedureId + ".md")).append("|\n");
                this.generateDetailedProcedureReport(procedureId, subprogramSpecificationProcedureTree, packageId, packageDeclaration);
                ++procedureId;
            }
        }
        data.append("\n\n").append("## Global Signals\n\n").append("Count: ");
        long signalsCount = ((PackageDeclarationTree)packageDeclaration.tree()).signals().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).count();
        data.append(signalsCount).append("\n\n");
        if (signalsCount > 0L) {
            data.append("| Name | Type | Default value | Description |\n").append("| --- | --- | --- | --- |\n");
            for (SignalDeclarationTree signal : ((PackageDeclarationTree)packageDeclaration.tree()).signals().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                for (IdentifierTree identifier : signal.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(signal.subtypeIndication().toStringWithWhitespaceBetweenEachTree()).append("|");
                    if (signal.expression() != null) {
                        data.append(signal.expression().toStringWithWhitespaceBetweenEachTree());
                    }
                    data.append("|").append(DesignHierarchyReport.sanitizeDescription(signal.doxygenComments())).append("|\n");
                }
            }
        }
        data.append("\n\n").append("## Global Variables\n\n").append("Count: ");
        long l = ((PackageDeclarationTree)packageDeclaration.tree()).variables().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).count();
        data.append(l).append("\n\n");
        if (l > 0L) {
            data.append("| Name | Type | Default value | Description |\n").append("| --- | --- | --- | --- |\n");
            for (VariableDeclarationTree variable : ((PackageDeclarationTree)packageDeclaration.tree()).variables().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                for (IdentifierTree identifier : variable.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(variable.subtypeIndication().toStringWithWhitespaceBetweenEachTree()).append("|");
                    if (variable.expression() != null) {
                        data.append(variable.expression().toStringWithWhitespaceBetweenEachTree());
                    }
                    data.append("|").append(DesignHierarchyReport.sanitizeDescription(variable.doxygenComments())).append("|\n");
                }
            }
        }
        data.append("\n\n").append("## Component Definitions\n\n").append("Count: ").append(((PackageDeclarationTree)packageDeclaration.tree()).components().size()).append("\n\n");
        if (!((PackageDeclarationTree)packageDeclaration.tree()).components().isEmpty()) {
            data.append("| Name | Description | Details | \n").append("| --- | --- | :---: |\n");
            int componentId = 1;
            for (ComponentDeclarationTree component : ((PackageDeclarationTree)packageDeclaration.tree()).components().stream().sorted(Comparator.comparingInt(Tree::line).thenComparingInt(Tree::column)).toList()) {
                data.append("| ").append(new HdlIssueLocation(packageDeclaration.file(), component.identifier()).markdown(this.config(), component.identifier().text())).append(" | ").append(DesignHierarchyReport.sanitizeDescription(component.doxygenComments())).append(" | ").append(this.linkToDetails("View Component Details", "package_" + packageId + "/component_" + componentId + ".md")).append(" |\n");
                this.generateDetailedComponentReport(packageId, componentId, packageDeclaration, component);
                ++componentId;
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Design Hierarchy Report](../design_hierarchy.md#vhdl-packages)"), "design/package_" + packageId + ".md");
    }

    private void generateDetailedComponentReport(int packageId, int componentId, PackageTreeFile packageDeclaration, ComponentDeclarationTree component) {
        StringBuilder data = new StringBuilder().append("# Component - ").append(component.identifier().text()).append("\n\n").append("## Summary\n\n").append("| Name | Location | Description |\n").append("| --- | --- | --- |\n").append("|").append(component.identifier().text()).append("|").append(new HdlIssueLocation(packageDeclaration.file(), component.identifier()).markdown(this.config())).append("|").append(DesignHierarchyReport.sanitizeDescription(component.doxygenComments())).append("|\n").append("\n\n").append("## Generics\n\n").append("Count: ");
        long genericsCount = component.generics().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).count();
        data.append(genericsCount).append("\n\n");
        if (genericsCount > 0L) {
            data.append("| Name | Type | Default value | Description |\n").append("| --- | --- | --- | --- |\n");
            for (InterfaceDeclarationTree generic : component.generics()) {
                for (IdentifierTree identifier : generic.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(generic.type().toStringWithWhitespaceBetweenEachTree()).append("|");
                    if (generic instanceof InterfaceSignalDeclarationTree && ((InterfaceSignalDeclarationTree)generic).defaultValue() != null) {
                        data.append(((InterfaceSignalDeclarationTree)generic).defaultValue());
                    }
                    data.append("|").append(DesignHierarchyReport.sanitizeDescription(generic.doxygenComments())).append("|\n");
                }
            }
        }
        data.append("\n\n").append("## Ports\n\n").append("Count: ");
        long portsCount = component.ports().stream().map(MultipleDeclarationTree::identifiers).flatMap(Collection::stream).count();
        data.append(portsCount).append("\n\n");
        if (portsCount > 0L) {
            data.append("| Name | Mode | Type | Description |\n").append("| --- | --- | --- | --- |\n");
            for (InterfaceDeclarationTree port : component.ports()) {
                for (IdentifierTree identifier : port.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageDeclaration.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(port.mode() != null ? port.mode() : "").append("|").append(port.type().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(port.doxygenComments())).append("|\n");
                }
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Package Report](../package_" + packageId + ".md#component-definitions)"), "design/package_" + packageId + "/component_" + componentId + ".md");
    }

    private void generateDetailedFunctionReport(int functionId, SubprogramSpecificationFunctionTree function, int packageId, PackageTreeFile packageTreeFile) {
        StringBuilder data = new StringBuilder().append("# Function - ").append(function.identifier().text()).append("\n\n").append("## Summary\n\n").append("| Name | Returned type | Description |\n").append("| --- | --- | --- |\n").append("|").append(new HdlIssueLocation(packageTreeFile.file(), function.designator()).markdown(this.config(), function.designator().toStringWithWhitespaceBetweenEachTree())).append("|").append(function.typeMark().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(function.doxygenComments())).append("|\n").append("\n\n").append("## Parameters\n\n").append("Count: ");
        long parametersCount = 0L;
        if (function.parameters() != null) {
            parametersCount = function.parameters().interfaces().stream().map(MultipleDeclarationTree::identifiers).mapToLong(List::size).sum();
        }
        data.append(parametersCount).append("\n\n");
        if (parametersCount > 0L) {
            data.append("| Name | Mode | Type | Description |\n").append("| --- | --- | --- | --- |\n");
            for (InterfaceDeclarationTree parameter : function.parameters().interfaces()) {
                for (IdentifierTree identifier : parameter.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageTreeFile.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(parameter.mode() != null ? parameter.mode() : "").append("|").append(parameter.type().toStringWithWhitespaceBetweenEachTree()).append("|").append(DesignHierarchyReport.sanitizeDescription(parameter.doxygenComments())).append("|\n");
                }
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Package Report](../package_" + packageId + ".md#functions)"), "design/package_" + packageId + "/function_" + functionId + ".md");
    }

    private void generateDetailedProcedureReport(int procedureId, SubprogramSpecificationProcedureTree procedure, int packageId, PackageTreeFile packageTreeFile) {
        StringBuilder data = new StringBuilder().append("# Procedure - ").append(procedure.identifier().text()).append("\n\n").append("## Summary\n\n").append("| Name | Description |\n").append("| --- | --- |\n").append("|").append(new HdlIssueLocation(packageTreeFile.file(), procedure.designator()).markdown(this.config(), procedure.designator().toStringWithWhitespaceBetweenEachTree())).append("|").append(DesignHierarchyReport.sanitizeDescription(procedure.doxygenComments())).append("|\n").append("\n\n").append("## Parameters\n\n").append("Count: ");
        long parametersCount = 0L;
        if (procedure.parameters() != null) {
            parametersCount = procedure.parameters().interfaces().stream().map(MultipleDeclarationTree::identifiers).mapToLong(List::size).sum();
        }
        data.append(parametersCount).append("\n\n");
        if (parametersCount > 0L) {
            data.append("| Name | Mode | Type | Description |\n").append("| --- | --- | --- | --- |\n");
            for (InterfaceDeclarationTree parameter : procedure.parameters().interfaces()) {
                for (IdentifierTree identifier : parameter.identifiers()) {
                    data.append("|").append(new HdlIssueLocation(packageTreeFile.file(), identifier).markdown(this.config(), identifier.text())).append("|").append(parameter.mode() != null ? parameter.mode() : "").append("|").append(parameter.type() != null ? parameter.type().toStringWithWhitespaceBetweenEachTree() : "").append("|").append(DesignHierarchyReport.sanitizeDescription(parameter.doxygenComments())).append("|\n");
                }
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Package Report](../package_" + packageId + ".md#procedures)"), "design/package_" + packageId + "/procedure_" + procedureId + ".md");
    }

    private void generateDetailedInstantiationReport(int instantiationId, Instance instance, int moduleId) {
        StringBuilder data = new StringBuilder().append("# Instantiation - ").append(instance.name()).append("\n\n").append("## Summary\n\n").append("| Name | Architecture | Description |\n").append("| --- | --- | --- |\n").append("| ").append(instance.locationAsMarkdown()).append(" | ");
        if (instance.module().architectureLocation() != null) {
            data.append(instance.module().architectureLocation().markdown(instance.module().architectureName()));
        }
        data.append(" | ").append(DesignHierarchyReport.sanitizeDescription(instance.doxygenComments())).append("|\n").append("\n\n").append("## Generics\n\n").append("Count: ");
        long genericsCount = instance.parameters().size();
        data.append(genericsCount).append("\n\n");
        if (genericsCount > 0L) {
            data.append("| Name | Value | Is equal to default value? | Is set? | Description |\n").append("| --- | --- | :---: | :---: | --- |\n");
            for (Parameter generic : instance.parameters().stream().sorted(Comparator.comparing(Parameter::name)).toList()) {
                data.append("|").append(generic.location().markdown(this.config(), generic.name())).append("|").append(generic.value()).append("|").append(this.asCheckmark(generic.isDefault())).append("|").append(this.asCheckmark(generic.isSet())).append("|").append(DesignHierarchyReport.sanitizeDescription(generic.comments())).append("|\n");
            }
        }
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to Module Report](../module_" + moduleId + ".md#instantiations)"), "design/module_" + moduleId + "/instantiation_" + instantiationId + ".md");
    }
}

