/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.GraphUtils;
import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.fsm.graph.Fsm;
import com.lintyservices.sonar.plugins.hdl.fsm.graph.FsmGraph;
import com.lintyservices.sonar.plugins.hdl.fsm.graph.Signal;
import com.lintyservices.sonar.plugins.hdl.fsm.graph.State;
import com.lintyservices.sonar.plugins.hdl.fsm.graph.Transition;
import com.lintyservices.yosys.objects.YosysFsmTransition;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.config.Configuration;

public class FSMsReport
extends Report {
    private final Fsms fsms;

    public FSMsReport(Fsms fsms, Configuration config) {
        super(config);
        this.fsms = fsms;
    }

    @Override
    public String fileName() {
        return "finite_state_machines.md";
    }

    @Override
    public String title() {
        return "Finite State Machines (FSM)";
    }

    @Override
    public String summary() {
        return "FSMs: " + this.fsms.size();
    }

    @Override
    public void generate() {
        File reportFsmDir = new File(this.reportsDir() + File.separator + "fsms");
        reportFsmDir.mkdirs();
        this.generateMainReport();
        this.generateDetailedReports();
        for (com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm fsm : this.fsms.fsms()) {
            this.generateFsmDiagram(fsm);
        }
    }

    private void generateMainReport() {
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(this.fsms.size()).append("**\n\n");
        if (this.fsms.size() > 0) {
            data.append("|ID|Name|Location|Graph|Reset State|States|Input Signals|Output Signals|Details|\n").append("|---|---|---|:---:|---|---|---:|---:|:---:|\n");
            for (com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm fsm : this.fsms.fsms()) {
                data.append("|").append(fsm.id()).append("|").append(fsm.name()).append("|").append(fsm.location().markdown()).append("|").append(this.linkToGraph("Open FSM Diagram", "fsm_states_" + fsm.id())).append("|").append(fsm.resetState() != null ? fsm.resetState() : "-").append("| Count: ").append(fsm.numberOfStates()).append("<br>").append(String.join((CharSequence)"<br>", fsm.states())).append("|").append(fsm.numberOfInputSignals()).append("|").append(fsm.numberOfOutputSignals()).append("|").append(this.linkToDetails("View FSM Details", "fsms/fsm_" + fsm.id() + ".md")).append("|").append("\n");
            }
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void generateDetailedReports() {
        for (com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm fsm : this.fsms.fsms()) {
            this.generateDetailedReport(fsm);
        }
    }

    private void generateDetailedReport(com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm fsm) {
        StringBuilder data = new StringBuilder().append("# FSM #").append(fsm.id()).append(": ").append(fsm.name()).append("\n\n");
        data.append("## Summary\n\n").append("|Name|Location|Graph|Reset State|States|Input Signals|Output Signals|\n").append("|---|---|:---:|---|---|---:|---:|\n").append(fsm.name()).append("|").append(fsm.location().markdown()).append("|").append(this.linkToGraph("Open FSM Diagram", "fsm_states_" + fsm.id())).append("|").append(fsm.resetState() != null ? fsm.resetState() : "-").append("| Count: ").append(fsm.numberOfStates()).append("<br>").append(String.join((CharSequence)"<br>", fsm.states())).append("|").append(fsm.numberOfInputSignals()).append("|").append(fsm.numberOfOutputSignals()).append("|").append("|\n").append("\n<br>\n\n");
        data.append("## Input Signals\n\n").append("Count: ").append(fsm.numberOfInputSignals()).append("\n\n").append("|Name|Declaration|\n").append("|---|---|\n");
        data.append(fsm.flattenedAndSortedInputSignals().stream().map(s -> String.format("|%s|%s|", s.name(), s.location().markdown(null))).collect(Collectors.joining("\n")));
        data.append("|\n\n").append("## Output Signals\n\n").append("Count: ").append(fsm.numberOfOutputSignals()).append("\n\n").append("|Name|Declaration|\n").append("|---|---|\n");
        data.append(fsm.outputSignals().stream().map(s -> String.format("|%s|%s|", s.name(), s.location().markdown(null))).collect(Collectors.joining("\n")));
        data.append("\n\n").append("## Transition table\n\n").append(this.transitionTable(fsm));
        this.writeChildReport(this.addBackLinks(data.toString(), "[Back to FSM Report](../" + this.fileName() + ")"), "fsms/fsm_" + fsm.id() + ".md");
    }

    private String transitionTable(com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm fsm) {
        StringBuilder data = new StringBuilder().append("|From|To|Input Control Signals|\n").append("|---|---|---|\n");
        List<YosysFsmTransition> transitions = fsm.transitions().stream().sorted(Comparator.comparing(YosysFsmTransition::from).thenComparing(YosysFsmTransition::to).thenComparing(t -> fsm.controlInSignalsByTransition((YosysFsmTransition)t).stream().map(YosysSignal::name).collect(Collectors.joining("\n")))).toList();
        for (YosysFsmTransition transition : transitions) {
            data.append("|").append(fsm.encodedStates().isEmpty() ? transition.from() : fsm.encodedStates().get(transition.from())).append("|").append(fsm.encodedStates().isEmpty() ? transition.to() : fsm.encodedStates().get(transition.to())).append("|").append(fsm.controlInSignalsByTransition(transition).stream().map(s -> String.format("%s: %s", s.name(), s.location().markdown(null))).collect(Collectors.joining("<br>"))).append("|\n");
        }
        return data.toString();
    }

    private void generateFsmDiagram(com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm fsm) {
        HashSet<State> states = new HashSet<State>();
        HashSet<Transition> transitions = new HashSet<Transition>();
        if (!fsm.encodedStates().isEmpty()) {
            for (Map.Entry entry : fsm.encodedStates().entrySet()) {
                states.add(new State((String)entry.getValue(), ((String)entry.getValue()).equals(fsm.resetState()), GraphUtils.url(fsm.location())));
            }
        } else {
            for (YosysFsmTransition yosysFsmTransition : fsm.transitions()) {
                states.add(new State(yosysFsmTransition.to(), yosysFsmTransition.to().equals(fsm.resetState()), GraphUtils.url(fsm.location())));
                states.add(new State(yosysFsmTransition.from(), yosysFsmTransition.from().equals(fsm.resetState()), GraphUtils.url(fsm.location())));
            }
        }
        for (YosysFsmTransition yosysFsmTransition : fsm.transitions()) {
            HashSet<Signal> signals = new HashSet<Signal>();
            for (int i = 0; i < yosysFsmTransition.controlIn().length; ++i) {
                if (!Set.of(Integer.valueOf(0), Integer.valueOf(1)).contains(yosysFsmTransition.controlIn()[i])) continue;
                for (YosysSignal signal : fsm.inputSignals().get(i)) {
                    signals.add(new Signal(signal));
                }
            }
            if (!fsm.encodedStates().isEmpty()) {
                transitions.add(new Transition(fsm.encodedStates().get(yosysFsmTransition.from()), fsm.encodedStates().get(yosysFsmTransition.to()), signals));
                continue;
            }
            transitions.add(new Transition(yosysFsmTransition.from(), yosysFsmTransition.to(), signals));
        }
        FsmGraph fsmGraph = new FsmGraph(new Fsm(states, transitions), String.format("FSM #%s - %s (%s)", fsm.id(), fsm.name(), fsm.location().file().getName()));
        this.writeGraph(fsmGraph, "fsm_states_" + fsm.id());
    }
}

