/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysHref;
import com.lintyservices.yosys.objects.YosysLocation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public class GraphUtils {
    private GraphUtils() {
    }

    public static String removeHtmlTags(String text) {
        return Jsoup.clean(text.replaceAll("(?i)</?br>", "\n"), "", Safelist.none(), new Document.OutputSettings().prettyPrint(false));
    }

    public static String url(YosysLocation location) {
        Object path = location.relativePath().startsWith(".") ? location.relativePath().substring(1) : "/" + location.relativePath();
        return String.format("%s#%s", path, location.beginLine());
    }

    public static void rewriteYosysGraphs(Path directoryPath, String filePrefix, String title) {
        if (directoryPath.toFile().listFiles() == null) {
            return;
        }
        for (File file : directoryPath.toFile().listFiles()) {
            String content;
            if (!file.getName().endsWith(".dot")) continue;
            try {
                content = Files.readString(file.toPath(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new LintyException("Cannot read file " + FileUtils.sanitizedPath(file.getAbsolutePath()), e);
            }
            content = GraphUtils.convertYosysHrefToGraphvizHref(content);
            content = GraphUtils.rewriteGraphTitle(file, filePrefix, title, content);
            try {
                Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new LintyException("Cannot write file " + FileUtils.sanitizedPath(file.getAbsolutePath()), e);
            }
        }
    }

    private static String convertYosysHrefToGraphvizHref(String content) {
        return Pattern.compile("href=\"(.+)\"").matcher(content).replaceAll(m -> new YosysHref(m.group(1)).vscodeHref());
    }

    private static String rewriteGraphTitle(File file, String filePrefix, String title, String content) {
        String id = file.getName().split(filePrefix)[1].split("\\.")[0];
        return Pattern.compile("\\{\\nlabel=\".+\";").matcher(content).replaceFirst(m -> "{\nlabel=<<b>" + title + " #" + id + "</b>>;\nlabelloc=\"t\"\nfontsize=\"30\"\nnode [\"fontname\"=\"Courier\"]\nedge [\"fontname\"=\"Courier\"]");
    }
}

