/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public class HdlProfiles
implements BuiltInQualityProfilesDefinition {
    private static final String LIGHT_LINT_CHECKS_PROFILE_NAME = "Light Lint Checks";
    static final String LIGHT_LINT_CHECKS_PROFILE_PATH = "/com/lintyservices/sonar/plugins/hdl/checks/active/HDL_Light_Lint_Checks.json";
    private static final String DEEP_CODE_CHECKS_PROFILE_NAME = "Deep Code Checks";
    private static final String DEEP_CODE_CHECKS_PROFILE_PATH = "/com/lintyservices/sonar/plugins/hdl/checks/active/HDL_Deep_Code_Checks.json";

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        this.definedDefaultProfile(context);
        this.defineDeepCodeChecksProfile(context);
    }

    private void definedDefaultProfile(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(LIGHT_LINT_CHECKS_PROFILE_NAME, "hdl");
        BuiltInQualityProfileJsonLoader.load(profile, "hdl", LIGHT_LINT_CHECKS_PROFILE_PATH);
        profile.done();
    }

    private void defineDeepCodeChecksProfile(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(DEEP_CODE_CHECKS_PROFILE_NAME, "hdl");
        profile.setDefault(false);
        for (String rule : BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(DEEP_CODE_CHECKS_PROFILE_PATH)) {
            profile.activateRule("hdl", rule);
        }
        profile.done();
    }
}

