/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.GraphUtils;
import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.reset.RDCs;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysRDC;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.sonar.api.config.Configuration;

public class RDCsReport
extends Report {
    private final RDCs rdcs;

    public RDCsReport(RDCs rdcs, Configuration config) {
        super(config);
        this.rdcs = rdcs;
    }

    @Override
    public String fileName() {
        return "reset_domain_crossings.md";
    }

    @Override
    public String title() {
        return "Reset Domain Crossings (RDC)";
    }

    @Override
    public String summary() {
        return "RDCs: " + this.rdcs.size();
    }

    @Override
    public void generate() {
        this.generateMainReport();
        String bugfinderDir = this.bugfinderDir() + File.separator + "rdcs";
        String reportDir = this.reportsDir() + File.separator + "rdcs";
        new File(reportDir).mkdirs();
        this.createLintyGraph(bugfinderDir, reportDir);
        this.updateAndMoveGraphs();
        this.generateHtmlPagesForDotGraphs();
    }

    private void generateMainReport() {
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(this.rdcs.size()).append("**\n\n");
        if (this.rdcs.size() > 0) {
            data.append("|ID|Graph|Reset (source)|Flip-flop (destination)|\n").append("|---|---|---|---|\n");
            for (YosysRDC rdc : this.rdcs.rdcs()) {
                data.append("|").append(rdc.id()).append("|").append(this.linkToGraph("Open RDC Graph", "rdcs/rdc_" + rdc.id())).append("|").append("Clock domain: ").append(rdc.origin().clockDomainUsage().clockDomain().location().markdown(rdc.origin().clockDomainUsage().clockDomain().name() + " (" + rdc.origin().clockDomainUsage().direction().value() + ")")).append("<br>").append("<br>Reset: ");
                Map<String, HdlIssueLocation> originLocations = this.rdcs.clockAndResetDomainUtils().originLocationsAsMap(rdc.reset());
                if (originLocations.size() > 1) {
                    data.append(rdc.reset().location() != null ? rdc.reset().location().markdown(rdc.reset().name()) : "Complex");
                }
                for (String key : originLocations.keySet().stream().sorted().toList()) {
                    if (originLocations.size() > 1) {
                        data.append("<br>&nbsp;&nbsp;-&nbsp;");
                    }
                    data.append(key).append(": ").append(originLocations.get(key).markdownWithLocationDisplay(this.config(), originLocations.get(key).message().replace(" origin", "").replaceAll("Port:.+", "Port")));
                }
                data.append("|").append("Clock domain: ").append(rdc.target().clockDomainUsage().clockDomain().location().markdown(rdc.target().clockDomainUsage().clockDomain().name() + " (" + rdc.target().clockDomainUsage().direction().value() + ")")).append("<br><br>").append("Flip-flop: ").append(rdc.target().cell().scopes() != null ? rdc.target().cell().scopes().instantiationPathAsMarkdown() : "").append(" > ").append(rdc.target().cell().location().markdown()).append("|").append("\n");
            }
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void createLintyGraph(String sourceDirPath, String destinationDirPath) {
    }

    private void updateAndMoveGraphs() {
        Path bugFinderGraphPath = Path.of(this.bugfinderDir() + File.separator + "rdcs", new String[0]);
        Path reportGraphPath = Path.of(this.graphsDir() + "/rdcs", new String[0]);
        if (bugFinderGraphPath.toFile().exists()) {
            RDCsReport.rewriteGraphs(bugFinderGraphPath);
            try {
                Files.move(bugFinderGraphPath, reportGraphPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new LintyException("Cannot move " + String.valueOf(bugFinderGraphPath) + " to " + String.valueOf(reportGraphPath), e);
            }
        }
    }

    private static void rewriteGraphs(Path path) {
        GraphUtils.rewriteYosysGraphs(path, "rdc_", "RDC");
    }

    private void generateHtmlPagesForDotGraphs() {
        File[] files;
        File rdcsDir = new File(this.graphsDir() + "/rdcs");
        for (File file : files = rdcsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".dot"))) {
            this.writeDotGraph(file.getName().substring(0, file.getName().length() - ".dot".length()), "rdcs");
        }
    }
}

