/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.google.gson.GsonBuilder;
import com.lintyservices.sonar.plugins.hdl.Graph;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public abstract class Report {
    private static final String REPORTS_DIR = ".linty/report/reports";
    private static final String GRAPHS_DIR = ".linty/report/html/graphs";
    private static final String BUGFINDER_DIR = ".linty/bugfinder";
    private final Configuration config;

    public Report(Configuration config) {
        this.config = config;
    }

    public abstract void generate();

    public abstract String fileName();

    public abstract String title();

    public abstract String summary();

    protected String addBackLinks(String content, String backlink) {
        return backlink + "\n\n<br>\n\n" + content + "\n\n<br>\n\n" + backlink;
    }

    protected void writeMainReport(String content, String filename) {
        this.writeFile(content, new File(this.reportsDir() + File.separator + filename));
    }

    protected void writeChildReport(String content, String path) {
        this.writeFile(content, new File(this.reportsDir() + File.separator + path));
    }

    protected void writeGraph(Graph graph, String fileName) {
        String content = String.format("<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n  <meta charset=\"UTF-8\" />\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n  <style>\n    body {\n      background-color: #1e1e1e;\n    }\n  </style>\n</head>\n\n<body>\n  <linty-viewer href=\"./%s.lintygraph\"></linty-viewer>\n  <script src=\"/_static/js/linty-viewer.js\"></script>\n</body>\n\n</html>\n", fileName);
        this.writeFile(new GsonBuilder().create().toJson(graph), new File(this.graphsDir() + File.separator + fileName + ".lintygraph"));
        this.writeFile(content, new File(this.graphsDir() + File.separator + fileName + "_graph.html"));
    }

    protected void writeDotGraph(String fileName, String directory) {
        String content = String.format("<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n  <meta charset=\"UTF-8\" />\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n  <style>\n    body {\n      background-color: #1e1e1e;\n    }\n  </style>\n</head>\n\n<body>\n  <linty-dot-viewer href=\"./%s.dot\"></linty-dot-viewer>\n  <script src=\"/_static/js/linty-viewer.js\"></script>\n</body>\n\n</html>\n", fileName);
        this.writeFile(content, new File(this.graphsDir() + File.separator + directory + File.separator + fileName + "_graph.html"));
    }

    protected void writeFile(String content, File file) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new LintyException("Cannot generate '" + FileUtils.sanitizedPath(file.getPath()) + "' report", e);
        }
    }

    protected String linkToDetails(String title, String link) {
        return String.format("[<img title=\"%s\" src=\"/_static/images/icon_details.png\" style=\"max-height: 25px; width: auto;\" alt=\"%s\">](%s)", title, title, link);
    }

    protected String linkToGraph(String title, String name) {
        return String.format("<a href=\"/graphs/%s_graph.html\"><img title=\"%s\" src=\"/_static/images/icon_graph.png\" style=\"max-height: 25px; width: auto;\" alt=\"%s\"></a>", name, title, title);
    }

    protected String asCheckmark(@Nullable Boolean value) {
        if (value == null) {
            return "Unknown";
        }
        if (value.booleanValue()) {
            return "&#10004;";
        }
        return "&#10007;";
    }

    protected String toLocationMarkdown(Set<YosysFlipFlop> flipFlops) {
        return flipFlops.stream().map(c -> "| " + c.location().markdown() + " |").collect(Collectors.toSet()).stream().sorted().collect(Collectors.joining("\n"));
    }

    protected Configuration config() {
        return this.config;
    }

    protected String reportsDir() {
        return this.projectBaseDir() + File.separator + REPORTS_DIR;
    }

    protected String graphsDir() {
        return this.projectBaseDir() + File.separator + GRAPHS_DIR;
    }

    protected String bugfinderDir() {
        return this.projectBaseDir() + File.separator + BUGFINDER_DIR;
    }

    protected static String sanitizeDescription(@Nullable String description) {
        return description != null ? description : "";
    }

    private String projectBaseDir() {
        return (String)this.config.get("sonar.projectBaseDir").get();
    }
}

