/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.utils.LintyException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;

public class ReportGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ReportGenerator.class);
    private final List<Report> reports;
    private final Configuration config;
    private final String sphinxReportDir;
    private final String reportsDir;
    private final String htmlDir;
    private final String graphsDir;
    private final String codeDir;
    private final String logsDir;
    private final File logFile;
    private final String projectBaseDir;

    public ReportGenerator(List<Report> reports, Configuration config) {
        this.reports = reports;
        this.config = config;
        this.projectBaseDir = (String)config.get("sonar.projectBaseDir").get();
        this.sphinxReportDir = this.projectBaseDir + "/.linty/report";
        this.reportsDir = this.sphinxReportDir + "/reports";
        this.htmlDir = this.sphinxReportDir + "/html";
        this.graphsDir = this.htmlDir + "/graphs";
        this.codeDir = this.htmlDir + "/code";
        this.logsDir = this.sphinxReportDir + "/logs";
        this.logFile = new File(this.logsDir + "/output.log");
    }

    public void generate() {
        LOG.info("--- Generating Report...");
        this.initReportDir();
        this.createSphinxFiles();
        for (Report report : this.reports) {
            report.generate();
        }
        this.copySourceCode();
        this.executeMakeHtmlSphinx();
        LOG.info("--- Generating Report: Done");
    }

    private void initReportDir() {
        try {
            FileUtils.deleteDirectory(new File(this.sphinxReportDir));
        }
        catch (IOException e) {
            throw new LintyException("Cannot delete report directory: " + this.sphinxReportDir, e);
        }
        this.createDirectory(this.sphinxReportDir);
        this.createDirectory(this.reportsDir);
        this.createDirectory(this.logsDir);
    }

    private void createSphinxFiles() {
        this.copyDirectoryFromResources("_static");
        this.copyDirectoryFromResources("_templates");
        this.copyFileFromResources("index.rst");
        this.copyFileFromResources("Makefile");
        this.createConfFile();
        this.createDirectory(this.htmlDir);
        this.createDirectory(this.graphsDir);
        this.createDirectory(this.codeDir);
        this.copyFileFromResources("html/code-viewer.html");
    }

    private void createDirectory(String path) {
        try {
            Files.createDirectories(Path.of(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LintyException("Cannot create directory: " + path, e);
        }
    }

    private void executeMakeHtmlSphinx() {
        Process process;
        String errorMessage = "HTML report generation failed.\nPlease, check log at " + com.lintyservices.utils.FileUtils.sanitizedPath(this.logFile.getAbsolutePath());
        String venvPath = "/opt/sonar-scanner/sphinx/bin/activate";
        Object command = "";
        if (new File(venvPath).exists()) {
            command = (String)command + "source /opt/sonar-scanner/sphinx/bin/activate && ";
        }
        command = (String)command + "make html";
        ProcessBuilder pb = new ProcessBuilder(new String[]{"bash", "-c", command}).redirectOutput(ProcessBuilder.Redirect.appendTo(this.logFile)).redirectError(ProcessBuilder.Redirect.appendTo(this.logFile));
        pb.directory(new File(this.sphinxReportDir));
        try {
            process = pb.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new LintyException(errorMessage);
        }
        process.destroy();
        if (process.exitValue() != 0) {
            throw new LintyException(errorMessage);
        }
    }

    private void copySourceCode() {
        Optional sonarSources = this.config.get("sonar.sources");
        List sourceCodeDirectories = sonarSources.map(s -> Arrays.stream(s.split(",")).toList()).orElseGet(() -> List.of("."));
        ArrayList<IOFileFilter> filters = new ArrayList<IOFileFilter>();
        this.fileSuffixes().forEach(s -> filters.add(FileFilterUtils.suffixFileFilter(s)));
        filters.add(FileFilterUtils.directoryFileFilter());
        sourceCodeDirectories.forEach(d -> {
            File source2 = new File(this.projectBaseDir + File.separator + d);
            File target = new File(this.codeDir + File.separator + d);
            try {
                target.mkdirs();
                FileUtils.copyDirectory(source2, target, new OrFileFilter((List<IOFileFilter>)filters));
            }
            catch (IOException e) {
                throw new LintyException("Cannot copy source code from " + String.valueOf(source2) + " to " + String.valueOf(target), e);
            }
        });
        this.deleteEmptyDirectories();
    }

    private Set<String> vhdlFileSuffixes() {
        String[] vhdlFileSuffixes = this.config.getStringArray("sonar.vhdl.file.suffixes");
        if (vhdlFileSuffixes == null || vhdlFileSuffixes.length == 0) {
            vhdlFileSuffixes = StringUtils.split(".vhdl,.vhd");
        }
        return Arrays.stream(vhdlFileSuffixes).collect(Collectors.toSet());
    }

    private Set<String> verilogFileSuffixes() {
        String[] verilogFileSuffixes = this.config.getStringArray("sonar.verilog.file.suffixes");
        if (verilogFileSuffixes == null || verilogFileSuffixes.length == 0) {
            verilogFileSuffixes = StringUtils.split(".v,.vh,.sv,.svh");
        }
        return Arrays.stream(verilogFileSuffixes).collect(Collectors.toSet());
    }

    private List<String> fileSuffixes() {
        HashSet<String> fileSuffixes = new HashSet<String>();
        fileSuffixes.addAll(this.vhdlFileSuffixes());
        fileSuffixes.addAll(this.verilogFileSuffixes());
        return fileSuffixes.stream().sorted().toList();
    }

    private void deleteEmptyDirectories() {
        try (Stream<Path> stream = Files.walk(Paths.get(this.codeDir, new String[0]), new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(File::isDirectory).forEach(File::delete);
        }
        catch (IOException e) {
            throw new LintyException("Cannot delete empty directories", e);
        }
    }

    private void createConfFile() {
        String content;
        String confFileName = "conf.py";
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(confFileName);){
            content = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            StringBuilder fileSuffixes = new StringBuilder();
            for (String suffix : this.fileSuffixes()) {
                fileSuffixes.append("    '").append(suffix).append("': 'markdown',\n");
            }
            String projectName = this.config.get("sonar.projectName").orElse((String)this.config.get("sonar.projectKey").get());
            String projectVersion = this.config.get("sonar.projectVersion").orElse("");
            content = content.replace("{{hdl_suffixes}}", fileSuffixes).replace("{{project_name}}", projectName).replace("{{project_version}}", projectVersion);
        }
        catch (IOException e) {
            throw new LintyException("Cannot read " + confFileName, e);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.sphinxReportDir + File.separator + confFileName));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new LintyException("Cannot write " + confFileName, e);
        }
    }

    private void copyFileFromResources(String source2) {
        InputStream ioStream = this.getClass().getClassLoader().getResourceAsStream(source2);
        if (ioStream == null) {
            throw new LintyException("Cannot read " + source2);
        }
        try {
            FileUtils.copyInputStreamToFile(ioStream, new File(this.sphinxReportDir + File.separator + source2));
        }
        catch (IOException e) {
            throw new LintyException("Cannot copy " + source2, e);
        }
    }

    private void copyDirectoryFromResources(String source2) {
        JarFile jar;
        ClassLoader classLoader = ReportGenerator.class.getClassLoader();
        URL url = classLoader.getResource(source2);
        String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
        try {
            jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new LintyException("Cannot load jar", e);
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(source2)) continue;
            String relativePath = name.substring(source2.length());
            File file = new File(this.sphinxReportDir + File.separator + source2 + File.separator + relativePath);
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                InputStream is = jar.getInputStream(entry);
                try (FileOutputStream fos = new FileOutputStream(file);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                throw new LintyException("Cannot writee", e);
            }
        }
        try {
            jar.close();
        }
        catch (IOException e) {
            throw new LintyException("Cannot close jar", e);
        }
    }
}

