/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.DesignHierarchy;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.ClockAndResetDomainUtils;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.sonar.plugins.hdl.reset.graph.InstanceForResetHierarchyGraph;
import com.lintyservices.sonar.plugins.hdl.reset.graph.ResetHierarchyGraph;
import com.lintyservices.yosys.objects.YosysResetDomain;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import com.lintyservices.yosys.objects.YosysScopes;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public class ResetDomainsReport
extends Report {
    private final ResetDomains resetDomains;
    private final DesignHierarchy designHierarchy;
    private final Set<File> filesToAnalyze;
    private final ClockAndResetDomainUtils clockAndResetDomainUtils;
    @Nullable
    private final YosysResetManagementModule rmm;

    public ResetDomainsReport(ResetDomains resetDomains, DesignHierarchy designHierarchy, Set<File> filesToAnalyze, HdlIssueLocation topModuleLocation, Configuration config) {
        super(config);
        this.resetDomains = resetDomains;
        this.designHierarchy = designHierarchy;
        this.rmm = resetDomains.resetManagementModule();
        this.filesToAnalyze = filesToAnalyze;
        this.clockAndResetDomainUtils = new ClockAndResetDomainUtils(filesToAnalyze, topModuleLocation, config);
    }

    @Override
    public String fileName() {
        return "reset_domains.md";
    }

    @Override
    public String title() {
        return "Reset Domains";
    }

    @Override
    public String summary() {
        return "Global reset domains: " + this.resetDomains.numberOfGlobalResetDomains();
    }

    @Override
    public void generate() {
        this.generateMainReport();
        new File(this.reportsDir() + File.separator + "reset_domains").mkdirs();
        this.generateDetailedReports();
        this.generateResetHierarchyGraph();
    }

    private void generateMainReport() {
        String RESET_DOMAIN_TABLE_HEADER = "| Name: Origin | Graph | Asynchronous | Synchronous | Active&nbsp;High | Active&nbsp;Low | Details |\n| --- | :---: | :---: | :---: | :---: | :---: | :---: |\n";
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("## Reset Management Module (RMM)\n\n");
        if (this.rmm != null && this.rmm.isRmm(this.filesToAnalyze)) {
            data.append("**").append(this.rmm.moduleLocation().markdown(this.rmm.moduleName())).append("** instantiated as **").append(this.rmm.instanceLocation().markdown(this.rmm.instanceName())).append("**");
        } else {
            data.append("None identified.");
        }
        data.append("\n\n<br>\n\n*All global resets should be generated within a unique reset management module (RMM).*\n").append("*A dedicated RMM brings a lot in terms of reuse and portability. ").append("Because all vendor-specific reset elements are generated within the same module, ").append("it is easier to replace this module to target other FPGAs.*\n\n").append("## Global Reset Domains\n\n").append("Count: **").append(this.resetDomains.numberOfGlobalResetDomains()).append("**\n");
        int idIndex = 1;
        if (!this.resetDomains.simpleGlobalResetDomains().isEmpty() || !this.resetDomains.complexGlobalResetDomains().isEmpty()) {
            data.append(RESET_DOMAIN_TABLE_HEADER);
            if (!this.resetDomains.simpleGlobalResetDomains().isEmpty()) {
                data.append(this.resetDomainsAsMarkDown(this.resetDomains.simpleGlobalResetDomains(), idIndex));
                idIndex += this.resetDomains.simpleGlobalResetDomains().size();
            }
            if (!this.resetDomains.complexGlobalResetDomains().isEmpty()) {
                data.append(this.resetDomainsAsMarkDown(this.resetDomains.complexGlobalResetDomains(), idIndex));
                idIndex += this.resetDomains.complexGlobalResetDomains().size();
            }
        }
        data.append("\n<br>\n\n").append("*A reset domain is considered as global if:*\n").append("  - *It is used in several modules.*\n").append("  - *Or it is used in a single module and by at least 20% of the flip-flops in the design.*\n\n").append("\n").append("## Local Reset Domains\n\n").append("Count: **").append(this.resetDomains.numberOfLocalResetDomains()).append("**\n\n");
        if (!this.resetDomains.simpleLocalResetDomains().isEmpty() || !this.resetDomains.complexLocalResetDomains().isEmpty()) {
            data.append(RESET_DOMAIN_TABLE_HEADER);
            if (!this.resetDomains.simpleLocalResetDomains().isEmpty()) {
                data.append(this.resetDomainsAsMarkDown(this.resetDomains.simpleLocalResetDomains(), idIndex));
                idIndex += this.resetDomains.simpleLocalResetDomains().size();
            }
            if (!this.resetDomains.complexLocalResetDomains().isEmpty()) {
                data.append(this.resetDomainsAsMarkDown(this.resetDomains.complexLocalResetDomains(), idIndex));
            }
        }
        this.writeMainReport(data.toString(), "reset_domains.md");
    }

    private void generateDetailedReports() {
        int idIndex = 1;
        for (YosysResetDomain resetDomain : this.resetDomains.allResetDomains()) {
            this.generateDetailedReport(resetDomain, idIndex);
            ++idIndex;
        }
    }

    private void generateDetailedReport(YosysResetDomain domain, int idIndex) {
        Map<String, HdlIssueLocation> originLocations = this.clockAndResetDomainUtils.originLocationsAsMap(domain);
        StringBuilder data = new StringBuilder().append("# Reset Domain Details\n\n").append("## Summary\n\n").append("| Name: Origin | Graph | Global | Local | Asynchronous | Synchronous | Active&nbsp;High | Active&nbsp;Low | Number of flip-flops<br>using this reset domain | Number of instances<br>using this reset domain |\n").append("| --- | :---: | :---: | :---: | :---: | :---: | :---: | :---: | ---: | ---: |\n").append("|");
        if (originLocations.size() > 1) {
            data.append("**Complex:** ");
        }
        data.append("**").append(domain.location() != null ? domain.location().markdown(domain.name()) : "").append("**");
        for (String key : originLocations.keySet().stream().sorted().toList()) {
            data.append("<br>&nbsp;&nbsp;-&nbsp;").append("**").append(key).append("**: ").append(originLocations.get(key).markdownWithLocationDisplay(this.config(), originLocations.get(key).message().replace(" origin", "").replaceAll("Port:.+", "Port")));
        }
        data.append("|").append(this.linkToGraph("Open Reset Hierarchy Graph", "reset_hierarchy")).append("|").append(this.asCheckmark(domain.global())).append("|").append(this.asCheckmark(domain.local())).append("|").append(this.asCheckmark(domain.asynchronous())).append("|").append(this.asCheckmark(domain.synchronous())).append("|").append(this.asCheckmark(domain.activeHigh())).append("|").append(this.asCheckmark(domain.activeLow())).append("|**").append(domain.flipFlops()).append("**/").append(Math.round(100.0 * (double)domain.flipFlops().intValue() / domain.percentageFlipFlops())).append(" (").append(String.format("%.02f", domain.percentageFlipFlops())).append("%)").append("|**").append(domain.modules()).append("**/").append(this.designHierarchy.numberOfInstances()).append("|\n").append("\n\n").append(this.instancesUsingResetDomain(domain)).append("\n\n").append("## Flip-flops using this reset domain\n\n").append("**Count: ").append(domain.flipFlops()).append("**\n\n").append("### Asynchronous usage\n\n").append("| Count: ").append(domain.asynchronousFFs().size()).append(" |\n").append("| --- |\n").append(this.toLocationMarkdown(domain.asynchronousFFs())).append("\n\n").append("### Synchronous usage\n\n").append("| Count: ").append(domain.synchronousFFs().size()).append(" |\n").append("| --- |\n").append(this.toLocationMarkdown(domain.synchronousFFs())).append("\n\n").append("### Active-high usage\n\n").append("| Count: ").append(domain.activeHighFFs().size()).append(" |\n").append("| --- |\n").append(this.toLocationMarkdown(domain.activeHighFFs())).append("\n\n").append("### Active-low usage\n\n").append("| Count: ").append(domain.activeLowFFs().size()).append(" |\n").append("| --- |\n").append(this.toLocationMarkdown(domain.activeLowFFs())).append("\n\n").append("\n\n<br>\n\n").append("Note that there could be fewer source code locations than the number of flip-flops ").append("because several flip-flops can be inferred from the same piece of code.").append("<br>\n<br>\n\n");
        this.writeMainReport(this.addBackLinks(data.toString(), "[Back to Reset Domains Report](../reset_domains.md)"), "reset_domains/reset_domain_" + idIndex + ".md");
    }

    private void generateResetHierarchyGraph() {
        this.writeGraph(new ResetHierarchyGraph(new InstanceForResetHierarchyGraph(this.designHierarchy.top(), this.resetDomains.globalResetDomains())), "reset_hierarchy");
    }

    private String resetDomainsAsMarkDown(List<YosysResetDomain> domains, int idIndex) {
        StringBuilder data = new StringBuilder();
        int index = idIndex;
        for (YosysResetDomain domain : domains) {
            data.append("|");
            Map<String, HdlIssueLocation> originLocations = this.clockAndResetDomainUtils.originLocationsAsMap(domain);
            if (originLocations.size() > 1) {
                data.append("**Complex:** ");
            }
            data.append("**").append(domain.location() != null ? domain.location().markdown(domain.name()) : "").append("**");
            for (String key : originLocations.keySet().stream().sorted().toList()) {
                data.append("<br>&nbsp;&nbsp;-&nbsp;").append("**").append(key).append("**: ").append(originLocations.get(key).markdownWithLocationDisplay(this.config(), originLocations.get(key).message().replace(" origin", "").replaceAll("Port:.+", "Port")));
            }
            data.append("|").append(this.linkToGraph("Open Reset Hierarchy Graph", "reset_hierarchy")).append("|").append(this.asCheckmark(domain.asynchronous())).append("|").append(this.asCheckmark(domain.synchronous())).append("|").append(this.asCheckmark(domain.activeHigh())).append("|").append(this.asCheckmark(domain.activeLow())).append("|").append(this.linkToDetails("View Reset Domain Details", "reset_domains/reset_domain_" + index + ".md")).append("|\n");
            ++index;
        }
        return data.toString();
    }

    private String instancesUsingResetDomain(YosysResetDomain domain) {
        Set asynchronousActiveHigh = domain.usedInInstancesAsynchronousActiveHigh().stream().map(YosysScopes::instantiationPathAsMarkdown).collect(Collectors.toSet());
        Set asynchronousActiveLow = domain.usedInInstancesAsynchronousActiveLow().stream().map(YosysScopes::instantiationPathAsMarkdown).collect(Collectors.toSet());
        Set synchronousActiveHigh = domain.usedInInstancesSynchronousActiveHigh().stream().map(YosysScopes::instantiationPathAsMarkdown).collect(Collectors.toSet());
        Set synchronousActiveLow = domain.usedInInstancesSynchronousActiveLow().stream().map(YosysScopes::instantiationPathAsMarkdown).collect(Collectors.toSet());
        HashSet all = new HashSet();
        all.addAll(asynchronousActiveHigh);
        all.addAll(asynchronousActiveLow);
        all.addAll(synchronousActiveHigh);
        all.addAll(synchronousActiveLow);
        List sortedInstances = all.stream().sorted().toList();
        StringBuilder markdown = new StringBuilder().append("## Instances using this reset domain\n\n").append("**Count: ").append(all.size()).append("**\n\n").append("| Instance | Asynchronous | Synchronous | Active&nbsp;High | Active&nbsp;Low\n").append("| --- | :---: | :---: | :---: | :---: |\n");
        for (String instance : sortedInstances) {
            markdown.append("|").append(instance).append("|").append(this.asCheckmark(asynchronousActiveHigh.contains(instance) || asynchronousActiveLow.contains(instance))).append("|").append(this.asCheckmark(synchronousActiveHigh.contains(instance) || synchronousActiveLow.contains(instance))).append("|").append(this.asCheckmark(asynchronousActiveHigh.contains(instance) || synchronousActiveHigh.contains(instance))).append("|").append(this.asCheckmark(asynchronousActiveLow.contains(instance) || synchronousActiveLow.contains(instance))).append("|\n");
        }
        return markdown.toString();
    }
}

