/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import java.util.List;
import org.sonar.api.config.Configuration;

public class SummaryReport
extends Report {
    private final List<Report> reports;

    public SummaryReport(List<Report> reports, Configuration config) {
        super(config);
        this.reports = reports;
    }

    @Override
    public String fileName() {
        return "index.md";
    }

    @Override
    public String title() {
        return "Summary Report";
    }

    @Override
    public String summary() {
        return "";
    }

    @Override
    public void generate() {
        String data = "# " + this.title() + "\n\n" + this.summaryReport();
        this.writeMainReport(data, this.fileName());
    }

    private String summaryReport() {
        StringBuilder data = new StringBuilder().append("|Report|Summary|Details|\n").append("|---|---|:---:|\n");
        for (Report report : this.reports) {
            data.append("|**").append(report.title()).append("**|").append(report.summary()).append("|").append(this.linkToDetails("View Details", report.fileName())).append("|\n");
        }
        return data.toString();
    }
}

