/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.yosys.objects.YosysClockDomain;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1034")
public class BothClockEdgesCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor {
    private ClockDomains domains;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.domains = (ClockDomains)clockDomains;
    }

    @Override
    public final void retrieveIssues() {
        Set withBothEdges = this.domains.clockDomains().stream().filter(YosysClockDomain::rising).filter(YosysClockDomain::falling).collect(Collectors.toSet());
        for (YosysClockDomain domain : withBothEdges) {
            this.issues().addPreciseIssueWithFlows(this.domains.clockAndResetDomainUtils().mainLocation(domain), String.format("Use only one edge for this clock domain%s.", domain.location() != null ? " for clock domain: " + domain.name() : ""), List.of(this.domains.clockAndResetDomainUtils().secondaryLocations(domain), domain.risingFFs().stream().map(ff -> new HdlIssueLocation(ff.location(), "Rising usage")).toList(), domain.fallingFFs().stream().map(ff -> new HdlIssueLocation(ff.location(), "Falling usage")).toList()));
        }
    }
}

