/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="HDL1013")
public class ClockManagementModuleCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor,
BugFinderClockManagementModuleAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private ClockDomains clockDomains;
    @Nullable
    private YosysClockManagementModule clockManagementModule;
    private Set<File> filesToAnalyze;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.clockDomains = (ClockDomains)clockDomains;
    }

    @Override
    public void setClockManagementModule(@Nullable YosysClockManagementModule clockManagementModule) {
        this.clockManagementModule = clockManagementModule;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        if (this.clockManagementModule != null && !this.clockManagementModule.isCmm(this.filesToAnalyze)) {
            this.issues().addPreciseIssueWithFlows(this.clockManagementModule.topModule().location(), "All clocks should be generated within a unique clock management module.", this.clockDomains.flows(new HdlIssueLocation(this.clockManagementModule.topModule().location())));
        }
    }
}

