/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="HDL1015")
public class ClockManagementModuleInstantiatedTopModuleCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockManagementModuleAwareVisitor,
FilesToAnalyzeAwareVisitor {
    @Nullable
    private YosysClockManagementModule clockManagementModule;
    private Set<File> filesToAnalyze;

    @Override
    public void setClockManagementModule(@Nullable YosysClockManagementModule clockManagementModule) {
        this.clockManagementModule = clockManagementModule;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        if (this.clockManagementModule != null && this.clockManagementModule.isCmm(this.filesToAnalyze) && !this.clockManagementModule.instantiatedInTopModule()) {
            this.issues().addPreciseIssue(this.clockManagementModule.instanceLocation(), "Instantiate this clock management module in the top module.");
        }
    }
}

