/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderConstantOutputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.Ports;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleNameAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.RangeUtils;
import com.lintyservices.yosys.objects.YosysPort;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1010")
public class ConstantOutputPortsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderConstantOutputPortsAwareVisitor,
TopModuleNameAwareVisitor {
    private static final boolean TOP_PARTIALLY_CONSTANT = true;
    private Set<YosysPort> constantOutputPorts;
    private String topModuleName;
    @RuleProperty(key="topPartiallyConstant", description="Set to 'true' to check partially constant output at top level, set to 'false' otherwise", type="BOOLEAN", defaultValue="true")
    private boolean topPartiallyConstant = true;

    @Override
    public void setConstantOutputPorts(Set<YosysPort> constantOutputPorts) {
        this.constantOutputPorts = constantOutputPorts;
    }

    @Override
    public void setTopModuleName(String topModuleName) {
        this.topModuleName = topModuleName;
    }

    @Override
    public final void retrieveIssues() {
        for (YosysPort yosysPort : this.getSingleDimensionPorts(this.constantOutputPorts)) {
            this.issues().addPreciseIssue(yosysPort.location(), yosysPort.name() + (String)(yosysPort.width() != 1 ? "(" + yosysPort.range() + ")" : "") + " output port is " + (yosysPort.bitOffsets().isEmpty() ? "" : "partially ") + "constant." + (String)(yosysPort.bitOffsets().isEmpty() ? "" : " Constant bit offsets: " + RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(yosysPort.bitOffsets()), yosysPort.upto()) + ".") + " Update design to remove this constant output port.");
        }
        for (Map.Entry entry : this.getMultiDimensionPorts(this.constantOutputPorts)) {
            for (Map.Entry port : ((Map)entry.getValue()).entrySet()) {
                StringBuilder message = new StringBuilder().append((String)port.getKey()).append(" output port is (partially) constant. ");
                for (YosysPort portDimension : (List)port.getValue()) {
                    String bitOffsets = "all";
                    if (!portDimension.bitOffsets().isEmpty()) {
                        bitOffsets = RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(portDimension.bitOffsets()), portDimension.upto());
                    }
                    message.append("Dimension: ").append(portDimension.dimensions()).append((String)(portDimension.width() != 1 ? "(" + portDimension.range() + ")" : "")).append(" => Constant bit offsets: ").append(bitOffsets).append(". ");
                }
                message.append("Update design to remove this constant output port.");
                this.issues().addPreciseIssue(((YosysPort)((List)port.getValue()).get(0)).location(), message.toString());
            }
        }
    }

    private Set<YosysPort> getSingleDimensionPorts(Set<YosysPort> ports) {
        return Ports.getSingleDimensionPorts(ports).stream().filter(this::belongsToTopModule).collect(Collectors.toSet());
    }

    private Set<Map.Entry<File, Map<String, List<YosysPort>>>> getMultiDimensionPorts(Set<YosysPort> ports) {
        return ports.stream().filter(YosysPort::isMultiDimensions).filter(this::belongsToTopModule).collect(Collectors.groupingBy(p -> p.location().file(), Collectors.groupingBy(YosysPort::shortName))).entrySet();
    }

    private boolean belongsToTopModule(YosysPort port) {
        if (this.topModuleName.equals(port.module().name())) {
            return this.topPartiallyConstant || port.bitOffsets().isEmpty();
        }
        return port.bitOffsets().isEmpty();
    }
}

