/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderDirectlyConnectedPortsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.yosys.objects.YosysConnectedPorts;
import com.lintyservices.yosys.objects.YosysPort;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1011")
public class DirectlyConnectedPortsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderDirectlyConnectedPortsAwareVisitor {
    private Set<YosysConnectedPorts> directlyConnectedPorts;

    @Override
    public void setDirectlyConnectedPorts(Set<YosysConnectedPorts> directlyConnectedPorts) {
        this.directlyConnectedPorts = directlyConnectedPorts;
    }

    @Override
    public final void retrieveIssues() {
        for (YosysConnectedPorts port : this.directlyConnectedPorts) {
            this.issues().addPreciseIssue(port.port().location(), String.format("Update design to remove direct connection between %s and %s.", port.port().name(), port.connectedPorts().stream().map(YosysPort::name).sorted().collect(Collectors.joining(", "))), port.connectedPorts().stream().map(p -> new HdlIssueLocation(p.location(), "Directly connected to")).toList());
        }
    }
}

