/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1025")
public class FsmMaxNumberOfStatesCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor {
    private static final int DEFAULT_MAX_NUMBER_OF_STATES = 16;
    private Fsms fsms;
    @RuleProperty(key="max", description="Maximum allowed number of states", defaultValue="16")
    public int max = 16;

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public final void retrieveIssues() {
        for (Fsm fsm : this.fsms.fsms()) {
            if (fsm.numberOfStates() <= this.max) continue;
            this.issues().addPreciseIssue(fsm.location(), String.format("Simplify this FSM. Actual number of states: %d. Maximum allowed number of states: %d.", fsm.numberOfStates(), this.max));
        }
    }
}

