/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import com.lintyservices.yosys.objects.YosysFsmTransition;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1029")
public class FsmMaxTargetStatesCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor {
    private static final int DEFAULT_MAX_TARGET_STATES = 2;
    private Fsms fsms;
    @RuleProperty(key="max", description="Maximum allowed number of target states", defaultValue="2")
    public int max = 2;

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public final void retrieveIssues() {
        block0: for (Fsm fsm : this.fsms.fsms()) {
            Map<String, List<YosysFsmTransition>> transitions = fsm.transitions().stream().collect(Collectors.groupingBy(YosysFsmTransition::from));
            for (Map.Entry<String, List<YosysFsmTransition>> entry : transitions.entrySet()) {
                if (entry.getValue().size() <= this.max) continue;
                this.issues().addPreciseIssue(fsm.location(), "Decrease FSM complexity. From at least one state, a transition is possible to more than " + this.max + " other state" + (this.max > 1 ? "s" : "") + ".");
                continue block0;
            }
        }
    }
}

