/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1024")
public class FsmMinNumberOfStatesCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor {
    private static final int DEFAULT_MIN_NUMBER_OF_STATES = 4;
    private Fsms fsms;
    @RuleProperty(key="min", description="Minimum allowed number of states", defaultValue="4")
    public int min = 4;

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public final void retrieveIssues() {
        for (Fsm fsm : this.fsms.fsms()) {
            if (fsm.numberOfStates() >= this.min) continue;
            this.issues().addPreciseIssue(fsm.location(), String.format("Replace this FSM with a more performant construct. Actual number of states: %d. Minimum allowed number of states: %d.", fsm.numberOfStates(), this.min));
        }
    }
}

