/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import com.lintyservices.yosys.objects.YosysLocation;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1028")
public class FsmSignalNamingConventionCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor {
    private static final String DEFAULT_FORMAT = "^sm_.+";
    private Fsms fsms;
    @RuleProperty(key="format", description="Regular expression to match for state signals.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^sm_.+")
    private String format = "^sm_.+";

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public final void retrieveIssues() {
        for (Fsm fsm : this.fsms.fsms()) {
            this.checkForIssue(fsm.name(), fsm.location());
        }
    }

    private void checkForIssue(String name, YosysLocation location) {
        if (!Pattern.compile(this.format, 32).matcher(name).matches()) {
            this.issues().addPreciseIssue(location, String.format("Rename this state signal to match the following regular expression: %s", this.format));
        }
    }
}

