/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileVerificLogCheck;
import com.lintyservices.yosys.objects.VerificLogItem;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="HDL1043")
public class LatchCheck
extends HdlCrossFileVerificLogCheck {
    @Override
    public final void retrieveIssues() {
        for (VerificLogItem item : this.filteredItems(Set.of("VHDL-1840", "VERI-2580"))) {
            String message;
            if (item.message().split("latch inferred").length == 2) {
                message = String.format("Remove this latch inferred %s.", item.message().split("latch inferred")[1].trim());
            } else {
                message = item.message();
                this.logMessageCannotBeCustomized("VHDL1043", item);
            }
            this.issues().addPreciseIssue(item.location(), message);
        }
    }
}

