/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.CDCsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderCDCsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.clock.CDCs;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysCDC;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="HDL1001")
public class ListClockDomainCrossingsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderCDCsAwareVisitor {
    private CDCs cdcs;

    @Override
    public void setCDCs(CDCsInterface cdcs) {
        this.cdcs = (CDCs)cdcs;
    }

    @Override
    public final void retrieveIssues() {
        for (YosysCDC cdc : this.cdcs.cdcs()) {
            String message = String.format("Review clock domain crossing between '%s' (target) and '%s' (origin)", String.join((CharSequence)", ", cdc.target().qPublicNames()), String.join((CharSequence)", ", cdc.origin().qPublicNames()));
            HdlIssueLocation primaryLocation = this.cdcs.dcUtils().flipFlopToIssueLocation(cdc.target().location(), "Target flip-flop");
            primaryLocation.setMessage(message);
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            secondaryLocations.add(this.cdcs.dcUtils().clockDomainUsageToIssueLocation(cdc.origin().clockDomainUsage(), "Origin"));
            secondaryLocations.addAll(this.cdcs.dcUtils().signalsToIssueLocations(cdc.origin()));
            secondaryLocations.add(this.cdcs.dcUtils().flipFlopToIssueLocation(cdc.origin().location(), "Origin"));
            secondaryLocations.add(this.cdcs.dcUtils().clockDomainUsageToIssueLocation(cdc.target().clockDomainUsage(), "Target"));
            secondaryLocations.addAll(this.cdcs.dcUtils().signalsToIssueLocations(cdc.target()));
            secondaryLocations.add(this.cdcs.dcUtils().flipFlopToIssueLocation(cdc.target().location(), "Target"));
            if (FileUtils.contains(this.cdcs.dcUtils().filesToAnalyze(), cdc.target().location().file())) {
                this.issues().addPreciseIssueWithFlows(primaryLocation, List.of(secondaryLocations));
                continue;
            }
            this.issues().addLineIssueWithFlows(cdc.target().location().file(), cdc.target().location().beginLine(), message, List.of(secondaryLocations));
        }
    }
}

