/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleLocationAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.yosys.objects.ResetClockDomainOriginType;
import com.lintyservices.yosys.objects.YosysClockOrResetDomain;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsPort;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="HDL1030")
public class MaxExternalResetCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor,
TopModuleLocationAwareVisitor {
    private ResetDomains resetDomains;
    private HdlIssueLocation topModuleLocation;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.resetDomains = (ResetDomains)resetDomains;
    }

    @Override
    public void setTopModuleLocation(HdlIssueLocation location) {
        this.topModuleLocation = location;
    }

    @Override
    public final void retrieveIssues() {
        List<YosysLocation> resetPortLocations = this.resetDomains.globalResetDomains().stream().map(YosysClockOrResetDomain::origins).flatMap(Collection::stream).filter(o -> o.type() == ResetClockDomainOriginType.TOP_LEVEL_PORT).map(o -> ((YosysResetClockDomainOriginAsPort)o).port().location()).toList();
        if (resetPortLocations.size() > 1) {
            this.issues().addPreciseIssue(this.topModuleLocation, "Reduce the number of external reset signals.", resetPortLocations.stream().map(l -> new HdlIssueLocation((YosysLocation)l, "Reset port")).toList());
        }
    }
}

