/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.yosys.objects.YosysResetDomain;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1039")
public class MultipleResetTypesCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor {
    private ResetDomains resetDomains;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.resetDomains = (ResetDomains)resetDomains;
    }

    @Override
    public final void retrieveIssues() {
        Set withBothTypes = this.resetDomains.allResetDomains().stream().filter(YosysResetDomain::asynchronous).filter(YosysResetDomain::synchronous).collect(Collectors.toSet());
        for (YosysResetDomain domain : withBothTypes) {
            this.issues().addPreciseIssueWithFlows(this.resetDomains.clockAndResetDomainUtils().mainLocation(domain), String.format("Do not use both synchronous and asynchronous resets%s.", domain.location() != null ? " for reset domain: " + domain.name() : ""), List.of(this.resetDomains.clockAndResetDomainUtils().secondaryLocations(domain), domain.asynchronousFFs().stream().map(ff -> new HdlIssueLocation(ff.location(), "Asynchronous usage")).toList(), domain.synchronousFFs().stream().map(ff -> new HdlIssueLocation(ff.location(), "Synchronous usage")).toList()));
        }
    }
}

