/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleLocationAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1002")
public class NumberOfClockDomainsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor,
TopModuleLocationAwareVisitor {
    private ClockDomains clockDomains;
    private HdlIssueLocation topModuleLocation;
    private static final int DEFAULT_MAX = 1;
    @RuleProperty(key="max", description="Maximum number of allowed clock domains. Note that a clock domain used for both rising and falling edges is counted as two separate clock domains.", type="INTEGER", defaultValue="1")
    private int max = 1;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.clockDomains = (ClockDomains)clockDomains;
    }

    @Override
    public void setTopModuleLocation(HdlIssueLocation location) {
        this.topModuleLocation = location;
    }

    @Override
    public final void retrieveIssues() {
        if (this.clockDomains.size() > this.max) {
            this.issues().addPreciseIssueWithFlows(this.topModuleLocation, String.format("Reduce the number of clock domains in this design. Maximum allowed number: %d. Actual number: %d.", this.max, this.clockDomains.size()), this.clockDomains.flows(this.topModuleLocation));
        }
    }
}

