/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="HDL1019")
public class ResetManagementClockManagementSameModuleCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockManagementModuleAwareVisitor,
BugFinderResetManagementModuleAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private YosysClockManagementModule clockManagementModule;
    private YosysResetManagementModule resetManagementModule;
    private Set<File> filesToAnalyze;

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public void setClockManagementModule(@Nullable YosysClockManagementModule clockManagementModule) {
        this.clockManagementModule = clockManagementModule;
    }

    @Override
    public void setResetManagementModule(@Nullable YosysResetManagementModule resetManagementModule) {
        this.resetManagementModule = resetManagementModule;
    }

    @Override
    public final void retrieveIssues() {
        if (this.clockManagementModule != null && this.clockManagementModule.isCmm(this.filesToAnalyze) && this.resetManagementModule != null && this.resetManagementModule.isRmm(this.filesToAnalyze) && !this.clockManagementModule.moduleName().equals(this.resetManagementModule.moduleName())) {
            this.issues().addPreciseIssue(this.resetManagementModule.topModule().location(), "Merge the clock management module and the reset management module into a single module.", List.of(new HdlIssueLocation(this.clockManagementModule.moduleLocation(), "Clock Management Module"), new HdlIssueLocation(this.resetManagementModule.moduleLocation(), "Reset Management Module")));
        }
    }
}

