/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.yosys.objects.YosysClockDomain;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1042")
public class RisingEdgeTransitionCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor {
    private ClockDomains domains;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.domains = (ClockDomains)clockDomains;
    }

    @Override
    public final void retrieveIssues() {
        Set withFallingEdges = this.domains.clockDomains().stream().filter(YosysClockDomain::falling).collect(Collectors.toSet());
        for (YosysClockDomain domain : withFallingEdges) {
            for (YosysFlipFlop flipFlop : domain.fallingFFs()) {
                this.issues().addPreciseIssueWithFlows(flipFlop.location(), String.format("Use rising edge instead%s.", domain.location() != null ? " for clock domain: " + domain.name() : ""), List.of(this.domains.clockAndResetDomainUtils().originLocations(domain)));
            }
        }
    }
}

