/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import com.lintyservices.yosys.objects.YosysClockDomain;
import com.lintyservices.yosys.objects.YosysScopes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1045")
public class TooManyClockDomainsPerInstantiationCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor {
    private static final int DEFAULT_MAX = 1;
    private ClockDomains domains;
    @RuleProperty(key="max", description="Maximum number of allowed clock domains per instance", type="INTEGER", defaultValue="1")
    private int max = 1;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.domains = (ClockDomains)clockDomains;
    }

    @Override
    public final void retrieveIssues() {
        HashSet<Usage> usage = new HashSet<Usage>();
        for (YosysClockDomain yosysClockDomain : this.domains.clockDomains()) {
            for (YosysScopes scope : yosysClockDomain.usedInInstancesFalling()) {
                usage.add(new Usage(scope, yosysClockDomain, ClockDirection.FALLING));
            }
            for (YosysScopes scope : yosysClockDomain.usedInInstancesRising()) {
                usage.add(new Usage(scope, yosysClockDomain, ClockDirection.RISING));
            }
        }
        for (Map.Entry entry : usage.stream().collect(Collectors.groupingBy(Usage::scope)).entrySet()) {
            if (((List)entry.getValue()).size() <= this.max) continue;
            ArrayList<List<? extends IssueLocationInterface>> flows = new ArrayList<List<? extends IssueLocationInterface>>();
            for (Usage u : (List)entry.getValue()) {
                flows.add(this.domains.flow(u.clockDomain, new HdlIssueLocation(((YosysScopes)entry.getKey()).instanceLocation()), u.direction));
            }
            this.issues().addPreciseIssueWithFlows(((YosysScopes)entry.getKey()).instanceLocation(), String.format("Decrease the number of clock domains used by this instance. Actual: %d. Max expected: %d.", ((List)entry.getValue()).size(), this.max), flows);
        }
    }

    record Usage(YosysScopes scope, YosysClockDomain clockDomain, ClockDirection direction) {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Usage)) {
                return false;
            }
            Usage u = (Usage)o;
            return u.scope.equals(this.scope) && u.clockDomain.equals(this.clockDomain) && u.direction == this.direction;
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 31 * result * this.scope.hashCode();
            result = 31 * result * this.clockDomain.hashCode();
            result = 31 * result * this.direction.hashCode();
            return result;
        }
    }
}

