/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.yosys.objects.YosysResetDomain;
import com.lintyservices.yosys.objects.YosysScopes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1046")
public class TooManyResetsPerInstantiationCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor {
    private static final int DEFAULT_MAX = 1;
    private ResetDomains domains;
    @RuleProperty(key="max", description="Maximum number of allowed global reset domains per instance", type="INTEGER", defaultValue="1")
    private int max = 1;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.domains = (ResetDomains)resetDomains;
    }

    @Override
    public final void retrieveIssues() {
        HashSet<Usage> usage = new HashSet<Usage>();
        for (YosysResetDomain yosysResetDomain : this.domains.globalResetDomains()) {
            for (YosysScopes scope : yosysResetDomain.usedInInstances()) {
                usage.add(new Usage(scope, yosysResetDomain));
            }
        }
        for (Map.Entry entry : usage.stream().collect(Collectors.groupingBy(Usage::scope)).entrySet()) {
            if (((List)entry.getValue()).size() <= this.max) continue;
            this.issues().addPreciseIssueWithFlows(((YosysScopes)entry.getKey()).instanceLocation(), String.format("Decrease the number of reset domains used by this instance. Actual: %d. Max expected: %d.", ((List)entry.getValue()).size(), this.max), ((List)entry.getValue()).stream().map(u -> this.domains.clockAndResetDomainUtils().originLocations(u.resetDomain)).collect(Collectors.toList()));
        }
    }

    record Usage(YosysScopes scope, YosysResetDomain resetDomain) {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Usage)) {
                return false;
            }
            Usage u = (Usage)o;
            return u.scope.equals(this.scope) && u.resetDomain.equals(this.resetDomain);
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = 31 * result * this.scope.hashCode();
            result = 31 * result * this.resetDomain.hashCode();
            return result;
        }
    }
}

