/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderTopLevelInputPortMultipleClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.RangeUtils;
import com.lintyservices.yosys.objects.YosysClockDomainUsage;
import com.lintyservices.yosys.objects.YosysPortClockDomains;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="HDL1004")
public class TopLevelInputPortUsedInMultipleClockDomainsPortCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderTopLevelInputPortMultipleClockDomainsAwareVisitor {
    private Set<YosysPortClockDomains> ports;

    @Override
    public void setTopLevelInputPortMultipleClockDomains(Set<YosysPortClockDomains> ports) {
        this.ports = ports;
    }

    @Override
    public final void retrieveIssues() {
        for (YosysPortClockDomains port : this.ports) {
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            for (YosysClockDomainUsage clockDomainUsage : port.clockDomainUsages()) {
                secondaryLocations.add(new HdlIssueLocation(clockDomainUsage.clockDomain().location(), clockDomainUsage.clockDomain().name() + "/" + clockDomainUsage.direction().value()));
            }
            this.issues().addPreciseIssue(port.port().location(), String.format("Update design to not use a top-level input port in multiple clock domains. %s%s is used in %d clock domains.", port.port().name(), port.port().bitOffsets().isEmpty() ? "" : " (bits: " + RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(port.port().bitOffsets()), port.port().upto()) + ")", port.clockDomainUsages().size()), secondaryLocations);
        }
    }
}

