/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleLocationAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import org.sonar.check.Rule;

@Rule(key="HDL1000")
public class TrackClockDomainsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor,
TopModuleLocationAwareVisitor {
    private ClockDomains clockDomains;
    private HdlIssueLocation topModuleLocation;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.clockDomains = (ClockDomains)clockDomains;
    }

    @Override
    public void setTopModuleLocation(HdlIssueLocation location) {
        this.topModuleLocation = location;
    }

    @Override
    public final void retrieveIssues() {
        this.issues().addPreciseIssueWithFlows(this.topModuleLocation, "Number of clock domains in this design: " + this.clockDomains.size(), this.clockDomains.flows(this.topModuleLocation));
    }
}

