/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnconnectedPortsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.UnconnectedPorts;
import com.lintyservices.yosys.helpers.port.PortDirection;
import com.lintyservices.yosys.objects.YosysPort;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1007")
public class UnconnectedInoutPortCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderUnconnectedPortsAwareVisitor {
    private static final boolean DETECT_PARTIALLY_CONNECTED = true;
    private static final String PORT_TYPE = "inout";
    @RuleProperty(key="detectPartiallyUnconnected", description="Set to 'true' to detect partially unconnected ports. Set to 'false' otherwise.", defaultValue="true")
    private boolean detectPartiallyUnconnected = true;
    private Set<YosysPort> unconnectedInoutPorts;

    @Override
    public void setUnconnectedPorts(Set<YosysPort> unconnectedPorts) {
        this.unconnectedInoutPorts = unconnectedPorts.stream().filter(p -> p.direction() == PortDirection.INOUT).filter(p -> this.detectPartiallyUnconnected || p.bitOffsets().isEmpty()).collect(Collectors.toSet());
    }

    @Override
    public final void retrieveIssues() {
        UnconnectedPorts.createSingleDimensionPortIssues(this.issues(), this.unconnectedInoutPorts, PORT_TYPE);
        UnconnectedPorts.createMultiDimensionPortIssues(this.issues(), this.unconnectedInoutPorts, PORT_TYPE);
    }
}

