/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.linter;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL002")
public class EndLineCharactersCheck
extends FileCheck
implements HdlDesignerCheck,
HdlCheck,
CharsetAwareVisitor {
    private static final String DEFAULT_FORMAT = "LF";
    @RuleProperty(key="endLineCharacter", description="Allowed values: 'CR', 'CRLF', 'LF'", defaultValue="LF")
    public String endLineCharacter = "LF";
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void retrieveIssuesOnFile(File file) {
        if (this.fileContainsIllegalEndLineCharacters(file)) {
            this.issues().addFileIssue(file, "Set all end-line characters to '" + this.endLineCharacter + "' on this file.");
        }
    }

    @Override
    public void validateCheckParameters() {
        if (!Arrays.asList("CRLF", "CR", DEFAULT_FORMAT).contains(this.endLineCharacter)) {
            throw new LintyException("endLineCharacter parameter is not valid.\nActual: '" + this.endLineCharacter + "'\nExpected: 'CR' or 'CRLF' or 'LF'");
        }
    }

    private boolean fileContainsIllegalEndLineCharacters(File file) {
        try {
            String fileContent = Files.asCharSource(file, this.charset).read();
            return "CR".equals(this.endLineCharacter) && Pattern.compile("(?s)\n").matcher(fileContent).find() || DEFAULT_FORMAT.equals(this.endLineCharacter) && Pattern.compile("(?s)\r").matcher(fileContent).find() || "CRLF".equals(this.endLineCharacter) && Pattern.compile("(?s)(\r(?!\n)|(?<!\r)\n)").matcher(fileContent).find();
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": File " + file.getName() + " cannot be read.", e);
        }
    }
}

