/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.linter;

import com.google.common.base.CharMatcher;
import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="HDL006")
public class NonAsciiCharacterCheck
extends FileCheck
implements FreeHdlDesignerCheck,
HdlCheck,
CharsetAwareVisitor {
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void retrieveIssuesOnFile(File file) {
        List<String> lines;
        try {
            lines = Files.readLines(file, this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + FileUtils.sanitizedPath(file.getAbsolutePath()), e);
        }
        int lineNumber = 1;
        for (String line : lines) {
            int columnNumber = 0;
            for (char c : line.toCharArray()) {
                if (!CharMatcher.ascii().matchesAllOf(String.valueOf(c))) {
                    this.issues().addPreciseIssue(new IssueLocation(file, lineNumber, columnNumber, lineNumber, columnNumber + 1, "Replace this non-ASCII character with an ASCII character."));
                }
                ++columnNumber;
            }
            ++lineNumber;
        }
    }
}

