/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.linter;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="HDL004")
public class TabCharacterCheck
extends FileCheck
implements FreeHdlDesignerCheck,
HdlCheck,
CharsetAwareVisitor {
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void retrieveIssuesOnFile(File file) {
        List<String> lines;
        try {
            lines = Files.readLines(file, this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + FileUtils.sanitizedPath(file.getAbsolutePath()), e);
        }
        for (String line : lines) {
            if (!line.contains("\t")) continue;
            this.issues().addFileIssue(file, "Replace all tab characters in this file by sequences of whitespaces.");
            break;
        }
    }
}

