/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.linter;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;

@Rule(key="HDL003")
public class TrailingWhitespaceCheck
extends FileCheck
implements FreeHdlDesignerCheck,
HdlCheck,
CharsetAwareVisitor {
    private static final String WHITESPACE = "\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}";
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void retrieveIssuesOnFile(File file) {
        List<String> lines;
        try {
            lines = Files.readLines(file, this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + FileUtils.sanitizedPath(file.getAbsolutePath()), e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.isEmpty() || !Pattern.matches("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]", line.subSequence(line.length() - 1, line.length()))) continue;
            this.issues().addLineIssue(file, i + 1, "Remove the useless trailing whitespaces at the end of this line.");
        }
    }
}

