/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.designhierarchy;

import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VhdlTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;

public class Module {
    private final YosysModule module;
    private final Set<ArchitectureTreeFile> architectureTreeFiles;
    private final Set<EntityTreeFile> entityTreeFiles;
    @Nullable
    private final String doxygenComments;
    private final boolean isThirdParty;

    public Module(YosysModule module, Set<EntityTreeFile> entityTreeFiles, Set<ArchitectureTreeFile> architectureTreeFiles, Set<File> filesToAnalyze) {
        this.module = module;
        this.entityTreeFiles = entityTreeFiles;
        this.architectureTreeFiles = architectureTreeFiles;
        this.doxygenComments = this.computeDoxygenComments();
        this.isThirdParty = module.blackbox() || module.location() == null || !FileUtils.contains(filesToAnalyze, module.location().file());
    }

    public String name() {
        return this.module.name();
    }

    public YosysLocation location() {
        return this.module.location();
    }

    @Nullable
    public YosysLocation architectureLocation() {
        return this.module.architectureLocation();
    }

    @Nullable
    public String architectureName() {
        if (this.architectureLocation() != null) {
            return VhdlTreeFileUtils.getArchitectureName(this.module.architectureLocation(), this.architectureTreeFiles);
        }
        return null;
    }

    public String library() {
        return this.module.library();
    }

    public boolean blackbox() {
        return this.module.blackbox();
    }

    public String doxygenComments() {
        return this.doxygenComments;
    }

    public boolean isThirdParty() {
        return this.isThirdParty;
    }

    @Nullable
    private String computeDoxygenComments() {
        String comments = null;
        for (EntityTreeFile tf : this.entityTreeFiles) {
            if (!tf.matchesYosysObject(this.module)) continue;
            comments = ((EntityDeclarationTree)tf.tree()).doxygenComments();
            break;
        }
        return comments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Module)) {
            return false;
        }
        Module m = (Module)o;
        return m.module.equals(this.module);
    }

    public int hashCode() {
        return this.module.hashCode();
    }
}

