/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.fsm;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.VhdlTreeFileUtils;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElementDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RecordTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.VariableDeclarationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysFsm;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fsms
implements FSMsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(Fsms.class);
    private final List<Fsm> fsms;
    private final Set<File> filesToAnalyze;

    public Fsms(Set<YosysFsm> yosysFsms, Set<File> vhdlFilesToAnalyze, Set<ArchitectureTreeFile> architectureTreeFiles, Set<TypeTreeFile> recordTypes) {
        this.filesToAnalyze = vhdlFilesToAnalyze;
        this.fsms = this.computeFsms(yosysFsms, architectureTreeFiles, recordTypes);
    }

    public Fsms(Set<YosysFsm> yosysFsms, Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
        this.fsms = this.computeFsms(yosysFsms);
    }

    public List<Fsm> fsms() {
        return this.fsms;
    }

    public int size() {
        return this.fsms.size();
    }

    private List<Fsm> computeFsms(Set<YosysFsm> yosysFsms) {
        return this.computeFsms(yosysFsms, null, null);
    }

    private List<Fsm> computeFsms(Set<YosysFsm> yosysFsms, @Nullable Set<ArchitectureTreeFile> architectureTreeFiles, @Nullable Set<TypeTreeFile> recordTypes) {
        HashSet<Fsm> fsms = new HashSet<Fsm>();
        for (YosysFsm yosysFsm : yosysFsms) {
            if (!FileUtils.contains(this.filesToAnalyze, yosysFsm.location().file())) continue;
            fsms.add(new Fsm(yosysFsm.id(), yosysFsm.name(), yosysFsm.location(), architectureTreeFiles != null && recordTypes != null ? this.getFsmType(yosysFsm.name(), this.getArchitectureTreeFile(architectureTreeFiles, yosysFsm), recordTypes) : null, yosysFsm.numberOfStates(), yosysFsm.inputSignals(), yosysFsm.outputSignals(), yosysFsm.transitions(), yosysFsm.encodedStates(), yosysFsm.states(), yosysFsm.resetState()));
        }
        return fsms.stream().sorted(Comparator.comparing(Fsm::id)).toList();
    }

    @Nullable
    private ArchitectureTreeFile getArchitectureTreeFile(Set<ArchitectureTreeFile> treeFiles, YosysFsm yosysFsm) {
        ArchitectureTreeFile architectureTreeFile = VhdlTreeFileUtils.getArchitectureTreeFiles(treeFiles, yosysFsm.module().name()).stream().filter(tf -> yosysFsm.belongsToFile(tf.file())).findFirst().orElse(null);
        if (architectureTreeFile != null) {
            return architectureTreeFile;
        }
        LOG.warn("[BugFinder] Cannot find architecture for:\n  - FSM name: " + yosysFsm.name());
        return null;
    }

    @Nullable
    private GenericTreeFile<SubtypeIndicationTree> getFsmType(String fsmName, @Nullable ArchitectureTreeFile architectureTreeFile, Set<TypeTreeFile> recordTypes) {
        if (architectureTreeFile == null) {
            return null;
        }
        String[] splitFsm = fsmName.split("\\.");
        String shortFsmName = splitFsm[splitFsm.length - 1];
        if (shortFsmName.contains("[")) {
            String[] splitName = shortFsmName.replace("]", "").split("\\[");
            GenericTreeFile<SubtypeIndicationTree> highLevelFsmType = this.getHighLevelFsmType(splitName[0], architectureTreeFile);
            return this.getActualTypeFromRecord(splitName, highLevelFsmType, recordTypes);
        }
        return this.getHighLevelFsmType(shortFsmName, architectureTreeFile);
    }

    private GenericTreeFile<SubtypeIndicationTree> getHighLevelFsmType(String fsmName, ArchitectureTreeFile architectures) {
        List<SignalDeclarationTree> signalDeclarations = ((ArchitectureBodyTree)architectures.tree()).allChildren(VhdlTree.Kind.SIGNAL_DECLARATION).stream().map(SignalDeclarationTree.class::cast).toList();
        for (SignalDeclarationTree signalDeclaration : signalDeclarations) {
            for (IdentifierTree identifier : signalDeclaration.identifiers()) {
                if (!identifier.text().equals(fsmName)) continue;
                return new GenericTreeFile<SubtypeIndicationTree>(signalDeclaration.subtypeIndication(), architectures.file());
            }
        }
        List<VariableDeclarationTree> variableDeclarations = ((ArchitectureBodyTree)architectures.tree()).allChildren(VhdlTree.Kind.VARIABLE_DECLARATION).stream().map(VariableDeclarationTree.class::cast).toList();
        for (VariableDeclarationTree variableDeclaration : variableDeclarations) {
            for (IdentifierTree identifier : variableDeclaration.identifiers()) {
                if (!identifier.text().equals(fsmName)) continue;
                return new GenericTreeFile<SubtypeIndicationTree>(variableDeclaration.subtypeIndication(), architectures.file());
            }
        }
        LOG.warn("[BugFinder] Cannot find FSM type for:\n  - FSM name: " + fsmName + "\n  - Architecture name: " + ((ArchitectureBodyTree)architectures.tree()).identifier().text() + "\n  - Architecture file path: " + FileUtils.sanitizedPath(architectures.file().getAbsolutePath()));
        return null;
    }

    @Nullable
    private GenericTreeFile<SubtypeIndicationTree> getActualTypeFromRecord(String[] fullPathRecordField, GenericTreeFile<SubtypeIndicationTree> currentType, Set<TypeTreeFile> recordTypes) {
        TypeTreeFile recordDefinition = recordTypes.stream().filter(r -> ((FullTypeDeclarationTree)r.tree()).identifier().text().equals(((SubtypeIndicationTree)currentType.tree()).typeName().firstToken().text())).findFirst().orElse(null);
        if (recordDefinition == null) {
            return null;
        }
        GenericTreeFile<SubtypeIndicationTree> elementType = null;
        for (ElementDeclarationTree element : ((RecordTypeDefinitionTree)((FullTypeDeclarationTree)recordDefinition.tree()).typeDefinition()).elementDeclarations()) {
            if (!element.identifiers().stream().map(i -> i.text().toLowerCase()).collect(Collectors.toSet()).contains(fullPathRecordField[1])) continue;
            elementType = new GenericTreeFile<SubtypeIndicationTree>(element.subtypeDefinition(), recordDefinition.file());
            break;
        }
        if (elementType == null) {
            return null;
        }
        if (fullPathRecordField.length > 2) {
            return this.getActualTypeFromRecord(Arrays.copyOfRange(fullPathRecordField, 1, fullPathRecordField.length), elementType, recordTypes);
        }
        return elementType;
    }
}

