/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.issues;

import com.lintyservices.slang.helpers.LocationRange;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.helpers.Tree;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.Issues;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssueWithFlows;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.yosys.objects.YosysLocation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class HdlIssues
extends Issues {
    public HdlIssues(Check check2) {
        super(check2);
    }

    public void addPreciseIssue(YosysLocation location, String message) {
        PreciseIssue issue = new PreciseIssue(this.check(), new HdlIssueLocation(location, message));
        this.allIssues().add(issue);
    }

    public void addPreciseIssue(YosysLocation location, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        PreciseIssue issue = new PreciseIssue(this.check(), new HdlIssueLocation(location, message), secondaryLocations);
        this.allIssues().add(issue);
    }

    public void addPreciseIssueWithFlows(YosysLocation location, String message, List<List<? extends IssueLocationInterface>> flows) {
        PreciseIssueWithFlows issue = new PreciseIssueWithFlows(this.check(), new HdlIssueLocation(location, message), flows);
        this.allIssues().add(issue);
    }

    public void addPreciseIssueWithFlows(HdlIssueLocation location, String message, List<List<? extends IssueLocationInterface>> flows) {
        PreciseIssueWithFlows issue = new PreciseIssueWithFlows(this.check(), new HdlIssueLocation(location, message), flows);
        this.allIssues().add(issue);
    }

    public void addPreciseIssueWithFlows(LocationRange location, String message, List<List<? extends IssueLocationInterface>> flows) {
        PreciseIssueWithFlows issue = new PreciseIssueWithFlows(this.check(), new HdlIssueLocation(location, message), flows);
        this.allIssues().add(issue);
    }

    public void addPreciseIssue(SyntaxNode node, String message) {
        this.addPreciseIssue(node, message, new ArrayList<HdlIssueLocation>());
    }

    public void addPreciseIssue(Tree tree, String message) {
        this.addPreciseIssue(tree, message, new ArrayList<HdlIssueLocation>());
    }

    public void addPreciseIssue(SyntaxNode.Trivia trivia, String message) {
        PreciseIssue issue = new PreciseIssue(this.check(), new HdlIssueLocation(trivia.location(), message));
        this.allIssues().add(issue);
    }

    public void addPreciseIssue(SyntaxNode node, String message, List<HdlIssueLocation> secondaryLocations) {
        if (this.validLocation(node.location())) {
            ArrayList<HdlIssueLocation> secondary = new ArrayList<HdlIssueLocation>(secondaryLocations);
            if (node.isPreprocessed() && node.originalLocation() != null) {
                secondary.add(new HdlIssueLocation(node.originalLocation(), "Original issue location"));
            }
            PreciseIssue issue = new PreciseIssue(this.check(), new HdlIssueLocation(node.location(), message), secondary);
            this.allIssues().add(issue);
        }
    }

    public void addPreciseIssue(Tree tree, String message, List<HdlIssueLocation> secondaryLocations) {
        if (this.validLocation(tree.location())) {
            PreciseIssue issue = new PreciseIssue(this.check(), new HdlIssueLocation(tree.location(), message), secondaryLocations);
            this.allIssues().add(issue);
        }
    }

    public void addPreciseIssue(LocationRange location, String message) {
        this.addPreciseIssue(location, message, new ArrayList<HdlIssueLocation>());
    }

    public void addPreciseIssue(LocationRange location, String message, List<HdlIssueLocation> secondaryLocations) {
        if (this.validLocation(location)) {
            PreciseIssue issue = new PreciseIssue(this.check(), new HdlIssueLocation(location, message), secondaryLocations);
            this.allIssues().add(issue);
        }
    }

    private boolean validLocation(@Nullable LocationRange location) {
        return location != null && !location.isEmpty();
    }
}

